/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.transport;

import com.amazon.opendistroforelasticsearch.security.OpenDistroSecurityPlugin;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auth.BackendRegistry;
import com.amazon.opendistroforelasticsearch.security.ssl.SslExceptionHandler;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.OpenDistroSecuritySSLRequestHandler;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.amazon.opendistroforelasticsearch.security.ssl.util.ExceptionUtils;
import com.amazon.opendistroforelasticsearch.security.ssl.util.SSLRequestHelper;
import com.amazon.opendistroforelasticsearch.security.support.Base64Helper;
import com.amazon.opendistroforelasticsearch.security.support.HeaderHelper;
import com.amazon.opendistroforelasticsearch.security.transport.InterClusterRequestEvaluator;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.base.Strings;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;

public class OpenDistroSecurityRequestHandler<T extends TransportRequest>
extends OpenDistroSecuritySSLRequestHandler<T> {
    private final BackendRegistry backendRegistry;
    private final AuditLog auditLog;
    private final InterClusterRequestEvaluator requestEvalProvider;
    private final ClusterService cs;

    OpenDistroSecurityRequestHandler(String action, TransportRequestHandler<T> actualHandler, ThreadPool threadPool, BackendRegistry backendRegistry, AuditLog auditLog, PrincipalExtractor principalExtractor, InterClusterRequestEvaluator requestEvalProvider, ClusterService cs, SslExceptionHandler sslExceptionHandler) {
        super(action, actualHandler, threadPool, principalExtractor, sslExceptionHandler);
        this.backendRegistry = backendRegistry;
        this.auditLog = auditLog;
        this.requestEvalProvider = requestEvalProvider;
        this.cs = cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void messageReceivedDecorate(T request, TransportRequestHandler<T> handler, TransportChannel transportChannel, Task task) throws Exception {
        String resolvedActionClass = request.getClass().getSimpleName();
        if (request instanceof BulkShardRequest && ((BulkShardRequest)request).items().length == 1) {
            resolvedActionClass = ((BulkShardRequest)request).items()[0].request().getClass().getSimpleName();
        }
        if (request instanceof TransportReplicationAction.ConcreteShardRequest) {
            resolvedActionClass = ((TransportReplicationAction.ConcreteShardRequest)request).getRequest().getClass().getSimpleName();
        }
        String initialActionClassValue = this.getThreadContext().getHeader("_opendistro_security_initial_action_class_header");
        ThreadContext.StoredContext sgContext = this.getThreadContext().newStoredContext(false);
        String originHeader = this.getThreadContext().getHeader("_opendistro_security_origin_header");
        if (!Strings.isNullOrEmpty((String)originHeader)) {
            this.getThreadContext().putTransient("_opendistro_security_origin", (Object)originHeader);
        }
        try {
            ShardSearchRequest sr;
            if (transportChannel.getChannelType() == null) {
                throw new RuntimeException("Can not determine channel type (null)");
            }
            String channelType = transportChannel.getChannelType();
            if (!channelType.equals("direct") && !channelType.equals("transport")) {
                TransportChannel innerChannel = this.getInnerChannel(transportChannel);
                channelType = innerChannel.getChannelType();
            }
            this.getThreadContext().putTransient("_opendistro_security_channel_type", (Object)channelType);
            this.getThreadContext().putTransient("_opendistro_security_action_name", (Object)task.getAction());
            if (request instanceof ShardSearchRequest && (sr = (ShardSearchRequest)request).source() != null && sr.source().suggest() != null) {
                this.getThreadContext().putTransient("_opendistro_security_issuggest", (Object)Boolean.TRUE);
            }
            if (channelType.equals("direct")) {
                String originalRemoteAddress;
                String userHeader = this.getThreadContext().getHeader("_opendistro_security_user_header");
                String injectedUserHeader = this.getThreadContext().getHeader("injected_user_header");
                if (Strings.isNullOrEmpty((String)userHeader)) {
                    if (!Strings.isNullOrEmpty((String)injectedUserHeader)) {
                        this.getThreadContext().putTransient("injected_user", (Object)injectedUserHeader);
                    }
                } else {
                    this.getThreadContext().putTransient("_opendistro_security_user", (Object)Objects.requireNonNull((User)Base64Helper.deserializeObject(userHeader)));
                }
                if (!Strings.isNullOrEmpty((String)(originalRemoteAddress = this.getThreadContext().getHeader("_opendistro_security_remote_address_header")))) {
                    this.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)new TransportAddress((InetSocketAddress)Base64Helper.deserializeObject(originalRemoteAddress)));
                }
                if (OpenDistroSecurityPlugin.isActionTraceEnabled()) {
                    this.getThreadContext().putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " DIR -> " + transportChannel.getChannelType() + " " + this.getThreadContext().getHeaders());
                }
                this.putInitialActionClassHeader(initialActionClassValue, resolvedActionClass);
                super.messageReceivedDecorate(request, handler, transportChannel, task);
                return;
            }
            if (!(HeaderHelper.isInterClusterRequest(this.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.getThreadContext()) || task.getAction().equals("internal:transport/handshake") || !task.getAction().startsWith("internal:") && !task.getAction().contains("["))) {
                this.auditLog.logMissingPrivileges(task.getAction(), (TransportRequest)request, task);
                this.log.error("Internal or shard requests (" + task.getAction() + ") not allowed from a non-server node for transport type " + transportChannel.getChannelType());
                transportChannel.sendResponse((Exception)new ElasticsearchSecurityException("Internal or shard requests not allowed from a non-server node for transport type " + transportChannel.getChannelType(), new Object[0]));
                return;
            }
            String principal = null;
            principal = (String)this.getThreadContext().getTransient("_opendistro_security_ssl_transport_principal");
            if (principal == null) {
                ElasticsearchSecurityException ex = new ElasticsearchSecurityException("No SSL client certificates found for transport type " + transportChannel.getChannelType() + ". Open Distro Security needs the Open Distro Security SSL plugin to be installed", new Object[0]);
                this.auditLog.logSSLException((TransportRequest)request, (Throwable)ex, task.getAction(), task);
                this.log.error("No SSL client certificates found for transport type " + transportChannel.getChannelType() + ". Open Distro Security needs the Open Distro Security SSL plugin to be installed");
                transportChannel.sendResponse((Exception)ex);
                return;
            }
            if (this.getThreadContext().getTransient("_opendistro_security_origin") == null) {
                this.getThreadContext().putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.TRANSPORT.toString());
            }
            if (HeaderHelper.isInterClusterRequest(this.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.getThreadContext())) {
                String originalRemoteAddress;
                String userHeader = this.getThreadContext().getHeader("_opendistro_security_user_header");
                String injectedUserHeader = this.getThreadContext().getHeader("injected_user_header");
                if (Strings.isNullOrEmpty((String)userHeader)) {
                    if (!Strings.isNullOrEmpty((String)injectedUserHeader)) {
                        this.getThreadContext().putTransient("injected_user", (Object)injectedUserHeader);
                    }
                } else {
                    this.getThreadContext().putTransient("_opendistro_security_user", (Object)Objects.requireNonNull((User)Base64Helper.deserializeObject(userHeader)));
                }
                if (!Strings.isNullOrEmpty((String)(originalRemoteAddress = this.getThreadContext().getHeader("_opendistro_security_remote_address_header")))) {
                    this.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)new TransportAddress((InetSocketAddress)Base64Helper.deserializeObject(originalRemoteAddress)));
                } else {
                    this.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)request.remoteAddress());
                }
            } else {
                if (SSLRequestHelper.containsBadHeader(this.getThreadContext(), "_opendistro_security_")) {
                    ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
                    this.auditLog.logBadHeaders((TransportRequest)request, task.getAction(), task);
                    this.log.error((Object)exception);
                    transportChannel.sendResponse((Exception)((Object)exception));
                    return;
                }
                User user = this.backendRegistry.authenticate((TransportRequest)request, principal, task, task.getAction());
                if (user == null) {
                    ThreadContext.remove((String)"user");
                    if (task.getAction().equals("cluster:admin/opendistro_security/whoami")) {
                        super.messageReceivedDecorate(request, handler, transportChannel, task);
                        return;
                    }
                    if (task.getAction().equals("cluster:monitor/nodes/liveness") || task.getAction().equals("internal:transport/handshake")) {
                        super.messageReceivedDecorate(request, handler, transportChannel, task);
                        return;
                    }
                    this.log.error("Cannot authenticate {} for {}", this.getThreadContext().getTransient("_opendistro_security_user"), (Object)task.getAction());
                    transportChannel.sendResponse((Exception)new ElasticsearchSecurityException("Cannot authenticate " + this.getThreadContext().getTransient("_opendistro_security_user"), new Object[0]));
                    return;
                }
                ThreadContext.put((String)"user", (String)user.getName());
                this.getThreadContext().putTransient("_opendistro_security_user", (Object)user);
                TransportAddress originalRemoteAddress = request.remoteAddress();
                if (originalRemoteAddress != null && originalRemoteAddress instanceof TransportAddress) {
                    this.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)originalRemoteAddress);
                } else {
                    this.log.error("Request has no proper remote address {}", (Object)originalRemoteAddress);
                    transportChannel.sendResponse((Exception)((Object)new ElasticsearchException("Request has no proper remote address", new Object[0])));
                    return;
                }
            }
            if (OpenDistroSecurityPlugin.isActionTraceEnabled()) {
                this.getThreadContext().putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " NETTI -> " + transportChannel.getChannelType() + " " + this.getThreadContext().getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_opendistro_security_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
            }
            this.putInitialActionClassHeader(initialActionClassValue, resolvedActionClass);
            super.messageReceivedDecorate(request, handler, transportChannel, task);
        }
        finally {
            if (OpenDistroSecurityPlugin.isActionTraceEnabled()) {
                this.getThreadContext().putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " FIN -> " + transportChannel.getChannelType() + " " + this.getThreadContext().getHeaders());
            }
            if (sgContext != null) {
                sgContext.close();
            }
        }
    }

    private void putInitialActionClassHeader(String initialActionClassValue, String resolvedActionClass) {
        if (initialActionClassValue == null) {
            if (this.getThreadContext().getHeader("_opendistro_security_initial_action_class_header") == null) {
                this.getThreadContext().putHeader("_opendistro_security_initial_action_class_header", resolvedActionClass);
            }
        } else if (this.getThreadContext().getHeader("_opendistro_security_initial_action_class_header") == null) {
            this.getThreadContext().putHeader("_opendistro_security_initial_action_class_header", initialActionClassValue);
        }
    }

    @Override
    protected void addAdditionalContextValues(String action, TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) throws Exception {
        boolean isInterClusterRequest = this.requestEvalProvider.isInterClusterRequest(request, localCerts, peerCerts, principal);
        if (isInterClusterRequest) {
            if (this.cs.getClusterName().value().equals(this.getThreadContext().getHeader("_opendistro_security_remotecn"))) {
                if (this.log.isTraceEnabled() && !action.startsWith("internal:")) {
                    this.log.trace("Is inter cluster request ({}/{}/{})", (Object)action, request.getClass(), (Object)request.remoteAddress());
                }
                this.getThreadContext().putTransient("_opendistro_security_ssl_transport_intercluster_request", (Object)Boolean.TRUE);
            } else {
                this.getThreadContext().putTransient("_opendistro_security_ssl_transport_trustedcluster_request", (Object)Boolean.TRUE);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("Is not an inter cluster request");
        }
        super.addAdditionalContextValues(action, request, localCerts, peerCerts, principal);
    }
}

