/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.transport;

import com.amazon.opendistroforelasticsearch.security.OpenDistroSecurityPlugin;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auth.BackendRegistry;
import com.amazon.opendistroforelasticsearch.security.configuration.ClusterInfoHolder;
import com.amazon.opendistroforelasticsearch.security.ssl.SslExceptionHandler;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.amazon.opendistroforelasticsearch.security.support.Base64Helper;
import com.amazon.opendistroforelasticsearch.security.transport.InterClusterRequestEvaluator;
import com.amazon.opendistroforelasticsearch.security.transport.OpenDistroSecurityRequestHandler;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

public class OpenDistroSecurityInterceptor {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private BackendRegistry backendRegistry;
    private AuditLog auditLog;
    private final ThreadPool threadPool;
    private final PrincipalExtractor principalExtractor;
    private final InterClusterRequestEvaluator requestEvalProvider;
    private final ClusterService cs;
    private final Settings settings;
    private final SslExceptionHandler sslExceptionHandler;
    private final ClusterInfoHolder clusterInfoHolder;

    public OpenDistroSecurityInterceptor(Settings settings, ThreadPool threadPool, BackendRegistry backendRegistry, AuditLog auditLog, PrincipalExtractor principalExtractor, InterClusterRequestEvaluator requestEvalProvider, ClusterService cs, SslExceptionHandler sslExceptionHandler, ClusterInfoHolder clusterInfoHolder) {
        this.backendRegistry = backendRegistry;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.principalExtractor = principalExtractor;
        this.requestEvalProvider = requestEvalProvider;
        this.cs = cs;
        this.settings = settings;
        this.sslExceptionHandler = sslExceptionHandler;
        this.clusterInfoHolder = clusterInfoHolder;
    }

    public <T extends TransportRequest> OpenDistroSecurityRequestHandler<T> getHandler(String action, TransportRequestHandler<T> actualHandler) {
        return new OpenDistroSecurityRequestHandler<T>(action, actualHandler, this.threadPool, this.backendRegistry, this.auditLog, this.principalExtractor, this.requestEvalProvider, this.cs, this.sslExceptionHandler);
    }

    public <T extends TransportResponse> void sendRequestDecorate(TransportInterceptor.AsyncSender sender, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        Map origHeaders0 = this.getThreadContext().getHeaders();
        User user0 = (User)this.getThreadContext().getTransient("_opendistro_security_user");
        String injectedUserString = (String)this.getThreadContext().getTransient("injected_user");
        String origin0 = (String)this.getThreadContext().getTransient("_opendistro_security_origin");
        Object remoteAddress0 = this.getThreadContext().getTransient("_opendistro_security_remote_address");
        String origCCSTransientDls = (String)this.getThreadContext().getTransient("_opendistro_security_dls_query_ccs");
        String origCCSTransientFls = (String)this.getThreadContext().getTransient("_opendistro_security_fls_fields_ccs");
        String origCCSTransientMf = (String)this.getThreadContext().getTransient("_opendistro_security_masked_fields_ccs");
        try (ThreadContext.StoredContext stashedContext = this.getThreadContext().stashContext();){
            RestoringTransportResponseHandler restoringHandler = new RestoringTransportResponseHandler(handler, stashedContext);
            this.getThreadContext().putHeader("_opendistro_security_remotecn", this.cs.getClusterName().value());
            HashMap<String, String> headerMap = new HashMap<String, String>(Maps.filterKeys((Map)origHeaders0, k -> k != null && (k.equals("_opendistro_security_conf_request") || k.equals("_opendistro_security_origin_header") || k.equals("_opendistro_security_remote_address_header") || k.equals("_opendistro_security_user_header") || k.equals("_opendistro_security_dls_query") || k.equals("_opendistro_security_fls_fields") || k.equals("_opendistro_security_masked_fields") || k.equals("_opendistro_security_source_field_context") && !(request instanceof SearchRequest) && !(request instanceof GetRequest) || k.startsWith("_opendistro_security_trace") || k.startsWith("_opendistro_security_initial_action_class_header"))));
            if (OpenDistroSecurityPlugin.GuiceHolder.getRemoteClusterService().isCrossClusterSearchEnabled() && this.clusterInfoHolder.isInitialized() && (action.equals("indices:admin/shards/search_shards") || action.equals("indices:data/read/search")) && !this.clusterInfoHolder.hasNode(connection.getNode()).booleanValue()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("remove dls/fls/mf because we sent a ccs request to a remote cluster");
                }
                headerMap.remove("_opendistro_security_dls_query");
                headerMap.remove("_opendistro_security_masked_fields");
                headerMap.remove("_opendistro_security_fls_fields");
            }
            if (OpenDistroSecurityPlugin.GuiceHolder.getRemoteClusterService().isCrossClusterSearchEnabled() && this.clusterInfoHolder.isInitialized() && !action.startsWith("internal:") && !action.equals("indices:admin/shards/search_shards") && !this.clusterInfoHolder.hasNode(connection.getNode()).booleanValue()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("add dls/fls/mf from transient");
                }
                if (origCCSTransientDls != null && !origCCSTransientDls.isEmpty()) {
                    headerMap.put("_opendistro_security_dls_query", origCCSTransientDls);
                }
                if (origCCSTransientMf != null && !origCCSTransientMf.isEmpty()) {
                    headerMap.put("_opendistro_security_masked_fields", origCCSTransientMf);
                }
                if (origCCSTransientFls != null && !origCCSTransientFls.isEmpty()) {
                    headerMap.put("_opendistro_security_fls_fields", origCCSTransientFls);
                }
            }
            this.getThreadContext().putHeader(headerMap);
            this.ensureCorrectHeaders(remoteAddress0, user0, origin0, injectedUserString);
            if (OpenDistroSecurityPlugin.isActionTraceEnabled()) {
                this.getThreadContext().putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " IC -> " + action + " " + this.getThreadContext().getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_opendistro_security_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
            }
            sender.sendRequest(connection, action, request, options, restoringHandler);
        }
    }

    private void ensureCorrectHeaders(Object remoteAdr, User origUser, String origin, String injectedUserString) {
        String userHeader;
        String remoteAddressHeader;
        if (origin != null && !origin.isEmpty() && this.getThreadContext().getHeader("_opendistro_security_origin_header") == null) {
            this.getThreadContext().putHeader("_opendistro_security_origin_header", origin);
        }
        if (origin == null && this.getThreadContext().getHeader("_opendistro_security_origin_header") == null) {
            this.getThreadContext().putHeader("_opendistro_security_origin_header", AuditLog.Origin.LOCAL.toString());
        }
        if (remoteAdr != null && remoteAdr instanceof TransportAddress && (remoteAddressHeader = this.getThreadContext().getHeader("_opendistro_security_remote_address_header")) == null) {
            this.getThreadContext().putHeader("_opendistro_security_remote_address_header", Base64Helper.serializeObject(((TransportAddress)remoteAdr).address()));
        }
        if ((userHeader = this.getThreadContext().getHeader("_opendistro_security_user_header")) == null) {
            if (origUser != null) {
                this.getThreadContext().putHeader("_opendistro_security_user_header", Base64Helper.serializeObject(origUser));
            } else if (StringUtils.isNotEmpty((String)injectedUserString)) {
                this.getThreadContext().putHeader("injected_user_header", injectedUserString);
            }
        }
    }

    private ThreadContext getThreadContext() {
        return this.threadPool.getThreadContext();
    }

    private class RestoringTransportResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final ThreadContext.StoredContext contextToRestore;
        private final TransportResponseHandler<T> innerHandler;

        private RestoringTransportResponseHandler(TransportResponseHandler<T> innerHandler, ThreadContext.StoredContext contextToRestore) {
            this.contextToRestore = contextToRestore;
            this.innerHandler = innerHandler;
        }

        public T read(StreamInput in) throws IOException {
            return (T)((TransportResponse)this.innerHandler.read(in));
        }

        public void handleResponse(T response) {
            List flsResponseHeader = (List)OpenDistroSecurityInterceptor.this.getThreadContext().getResponseHeaders().get("_opendistro_security_fls_fields");
            List dlsResponseHeader = (List)OpenDistroSecurityInterceptor.this.getThreadContext().getResponseHeaders().get("_opendistro_security_dls_query");
            List maskedFieldsResponseHeader = (List)OpenDistroSecurityInterceptor.this.getThreadContext().getResponseHeaders().get("_opendistro_security_masked_fields");
            this.contextToRestore.restore();
            if (response instanceof ClusterSearchShardsResponse && flsResponseHeader != null && !flsResponseHeader.isEmpty()) {
                if (OpenDistroSecurityInterceptor.this.log.isDebugEnabled()) {
                    OpenDistroSecurityInterceptor.this.log.debug("add flsResponseHeader as transient");
                }
                OpenDistroSecurityInterceptor.this.getThreadContext().putTransient("_opendistro_security_fls_fields_ccs", flsResponseHeader.get(0));
            }
            if (response instanceof ClusterSearchShardsResponse && dlsResponseHeader != null && !dlsResponseHeader.isEmpty()) {
                if (OpenDistroSecurityInterceptor.this.log.isDebugEnabled()) {
                    OpenDistroSecurityInterceptor.this.log.debug("add dlsResponseHeader as transient");
                }
                OpenDistroSecurityInterceptor.this.getThreadContext().putTransient("_opendistro_security_dls_query_ccs", dlsResponseHeader.get(0));
            }
            if (response instanceof ClusterSearchShardsResponse && maskedFieldsResponseHeader != null && !maskedFieldsResponseHeader.isEmpty()) {
                if (OpenDistroSecurityInterceptor.this.log.isDebugEnabled()) {
                    OpenDistroSecurityInterceptor.this.log.debug("add maskedFieldsResponseHeader as transient");
                }
                OpenDistroSecurityInterceptor.this.getThreadContext().putTransient("_opendistro_security_masked_fields_ccs", maskedFieldsResponseHeader.get(0));
            }
            this.innerHandler.handleResponse(response);
        }

        public void handleException(TransportException e) {
            this.contextToRestore.restore();
            this.innerHandler.handleException(e);
        }

        public String executor() {
            return this.innerHandler.executor();
        }
    }
}

