/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.support;

import com.amazon.opendistroforelasticsearch.security.OpenDistroSecurityPlugin;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotUtils;

public class SnapshotRestoreHelper {
    protected static final Logger log = LogManager.getLogger(SnapshotRestoreHelper.class);

    public static List<String> resolveOriginalIndices(RestoreSnapshotRequest restoreRequest) {
        SnapshotInfo snapshotInfo = SnapshotRestoreHelper.getSnapshotInfo(restoreRequest);
        if (snapshotInfo == null) {
            log.warn("snapshot repository '" + restoreRequest.repository() + "', snapshot '" + restoreRequest.snapshot() + "' not found");
            return null;
        }
        return SnapshotUtils.filterIndices((List)snapshotInfo.indices(), (String[])restoreRequest.indices(), (IndicesOptions)restoreRequest.indicesOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnapshotInfo getSnapshotInfo(RestoreSnapshotRequest restoreRequest) {
        RepositoriesService repositoriesService = Objects.requireNonNull(OpenDistroSecurityPlugin.GuiceHolder.getRepositoriesService(), "RepositoriesService not initialized");
        Repository repository = repositoriesService.repository(restoreRequest.repository());
        String threadName = Thread.currentThread().getName();
        SnapshotInfo snapshotInfo = null;
        try {
            SnapshotRestoreHelper.setCurrentThreadName("[generic]");
            for (SnapshotId snapshotId : ((RepositoryData)PlainActionFuture.get(arg_0 -> ((Repository)repository).getRepositoryData(arg_0))).getSnapshotIds()) {
                if (!snapshotId.getName().equals(restoreRequest.snapshot())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("snapshot found: {} (UUID: {})", (Object)snapshotId.getName(), (Object)snapshotId.getUUID());
                }
                snapshotInfo = repository.getSnapshotInfo(snapshotId);
                break;
            }
        }
        finally {
            SnapshotRestoreHelper.setCurrentThreadName(threadName);
        }
        return snapshotInfo;
    }

    private static void setCurrentThreadName(final String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.currentThread().setName(name);
                return null;
            }
        });
    }
}

