/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.support;

import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.tools.Hasher;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public final class OpenDistroSecurityUtils {
    protected static final Logger log = LogManager.getLogger(OpenDistroSecurityUtils.class);
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{env\\.([\\w]+)((\\:\\-)?[\\w]*)\\}");
    private static final Pattern ENVBC_PATTERN = Pattern.compile("\\$\\{envbc\\.([\\w]+)((\\:\\-)?[\\w]*)\\}");
    private static final Pattern ENVBASE64_PATTERN = Pattern.compile("\\$\\{envbase64\\.([\\w]+)((\\:\\-)?[\\w]*)\\}");
    public static Locale EN_Locale = OpenDistroSecurityUtils.forEN();

    private OpenDistroSecurityUtils() {
    }

    private static Locale forEN() {
        if ("en".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            return Locale.getDefault();
        }
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i != locales.length; ++i) {
            if (!"en".equalsIgnoreCase(locales[i].getLanguage())) continue;
            return locales[i];
        }
        return Locale.getDefault();
    }

    public static String evalMap(Map<String, Set<String>> map, String index) {
        if (map == null) {
            return null;
        }
        return map.keySet().stream().filter(key -> WildcardMatcher.from(key).test(index)).findAny().orElse(null);
    }

    @SafeVarargs
    public static <T> Map<T, T> mapFromArray(T ... keyValues) {
        if (keyValues == null) {
            return Collections.emptyMap();
        }
        if (keyValues.length % 2 != 0) {
            log.error("Expected even number of key/value pairs, got {}.", (Object)Arrays.toString(keyValues));
            return null;
        }
        HashMap<T, T> map = new HashMap<T, T>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return map;
    }

    public static String replaceEnvVars(String in, Settings settings) {
        if (in == null || in.isEmpty()) {
            return in;
        }
        if (settings == null || settings.getAsBoolean("opendistro_security.disable_envvar_replacement", Boolean.valueOf(false)).booleanValue()) {
            return in;
        }
        return OpenDistroSecurityUtils.replaceEnvVarsBC(OpenDistroSecurityUtils.replaceEnvVarsNonBC(OpenDistroSecurityUtils.replaceEnvVarsBase64(in)));
    }

    private static String replaceEnvVarsNonBC(String in) {
        Matcher matcher = ENV_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = OpenDistroSecurityUtils.resolveEnvVar(matcher.group(1), matcher.group(2), false);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String replaceEnvVarsBC(String in) {
        Matcher matcher = ENVBC_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = OpenDistroSecurityUtils.resolveEnvVar(matcher.group(1), matcher.group(2), true);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String replaceEnvVarsBase64(String in) {
        Matcher matcher = ENVBASE64_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = OpenDistroSecurityUtils.resolveEnvVar(matcher.group(1), matcher.group(2), false);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(new String(Base64.getDecoder().decode(replacement), StandardCharsets.UTF_8)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String resolveEnvVar(String envVarName, String mode, boolean bc) {
        String envVarValue = System.getenv(envVarName);
        if (envVarValue == null || envVarValue.isEmpty()) {
            if (mode != null && mode.startsWith(":-") && mode.length() > 2) {
                return bc ? Hasher.hash(mode.substring(2).toCharArray()) : mode.substring(2);
            }
            return null;
        }
        return bc ? Hasher.hash(envVarValue.toCharArray()) : envVarValue;
    }
}

