/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.support;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.Meta;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.VersionConflictEngineException;

public class ConfigHelper {
    private static final Logger LOGGER = LogManager.getLogger(ConfigHelper.class);

    public static void uploadFile(Client tc, String filepath, String index, CType cType, int configVersion) throws Exception {
        ConfigHelper.uploadFile(tc, filepath, index, cType, configVersion, false);
    }

    public static void uploadFile(Client tc, String filepath, String index, CType cType, int configVersion, boolean populateEmptyIfFileMissing) throws Exception {
        String configType = cType.toLCString();
        LOGGER.info("Will update '" + configType + "' with " + filepath + " and populate it with empty doc if file missing and populateEmptyIfFileMissing=" + populateEmptyIfFileMissing);
        if (!populateEmptyIfFileMissing) {
            ConfigHelper.fromYamlFile(filepath, cType, configVersion, 0L, 0L);
        }
        try (Reader reader = ConfigHelper.createFileOrStringReader(cType, configVersion, filepath, populateEmptyIfFileMissing);){
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(index).type(configVersion == 1 ? "security" : "_doc").id(configType).opType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{configType, ConfigHelper.readXContent(reader, XContentType.YAML)});
            String res = ((IndexResponse)tc.index(indexRequest).actionGet()).getId();
            if (!configType.equals(res)) {
                throw new Exception("   FAIL: Configuration for '" + configType + "' failed for unknown reasons. Pls. consult logfile of elasticsearch");
            }
            LOGGER.info("Doc with id '{}' and version {} is updated in {} index.", (Object)configType, (Object)configVersion, (Object)index);
        }
        catch (VersionConflictEngineException versionConflictEngineException) {
            LOGGER.info("Index {} already contains doc with id {}, skipping update.", (Object)index, (Object)configType);
        }
    }

    public static Reader createFileOrStringReader(CType cType, int configVersion, String filepath, boolean populateEmptyIfFileMissing) throws Exception {
        Reader reader = !populateEmptyIfFileMissing || new File(filepath).exists() ? new FileReader(filepath) : new StringReader(ConfigHelper.createEmptySdcYaml(cType, configVersion));
        return reader;
    }

    public static SecurityDynamicConfiguration<?> createEmptySdc(CType cType, int configVersion) throws Exception {
        SecurityDynamicConfiguration empty = SecurityDynamicConfiguration.empty();
        if (configVersion == 2) {
            empty.setCType(cType);
            empty.set_meta(new Meta());
            empty.get_meta().setConfig_version(configVersion);
            empty.get_meta().setType(cType.toLCString());
        }
        String string = DefaultObjectMapper.writeValueAsString(empty, false);
        SecurityDynamicConfiguration c = SecurityDynamicConfiguration.fromJson(string, cType, configVersion, -1L, -1L);
        return c;
    }

    public static String createEmptySdcYaml(CType cType, int configVersion) throws Exception {
        return DefaultObjectMapper.YAML_MAPPER.writeValueAsString(ConfigHelper.createEmptySdc(cType, configVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytesReference readXContent(Reader reader, XContentType xContentType) throws IOException {
        BytesReference retVal;
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)xContentType).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, reader);
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            retVal = BytesReference.bytes((XContentBuilder)builder);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> SecurityDynamicConfiguration<T> fromYamlReader(Reader yamlReader, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        try {
            SecurityDynamicConfiguration securityDynamicConfiguration = SecurityDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(yamlReader), ctype, version, seqNo, primaryTerm);
            return securityDynamicConfiguration;
        }
        finally {
            if (yamlReader != null) {
                yamlReader.close();
            }
        }
    }

    public static <T> SecurityDynamicConfiguration<T> fromYamlFile(String filepath, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return ConfigHelper.fromYamlReader(new FileReader(filepath), ctype, version, seqNo, primaryTerm);
    }

    public static <T> SecurityDynamicConfiguration<T> fromYamlString(String yamlString, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return ConfigHelper.fromYamlReader(new StringReader(yamlString), ctype, version, seqNo, primaryTerm);
    }
}

