/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.util;

import com.amazon.opendistroforelasticsearch.security.ssl.util.SSLConnectionTestResult;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSLConnectionTestUtil {
    private static final Logger logger = LogManager.getLogger(SSLConnectionTestUtil.class);
    public static final byte[] ES_PING_MSG = new byte[]{69, 83, -1, -1, -1, -1};
    public static final String DUAL_MODE_CLIENT_HELLO_MSG = "DUALCM";
    public static final String DUAL_MODE_SERVER_HELLO_MSG = "DUALSM";
    private static final int SOCKET_TIMEOUT_MILLIS = 10000;
    private boolean esPingReplyReceived;
    private boolean dualSSLProbeReplyReceived;
    private final String host;
    private final int port;
    private Socket overriddenSocket = null;
    private OutputStreamWriter testOutputStreamWriter = null;
    private InputStreamReader testInputStreamReader = null;

    public SSLConnectionTestUtil(String host, int port) {
        this.host = host;
        this.port = port;
        this.esPingReplyReceived = false;
        this.dualSSLProbeReplyReceived = false;
    }

    @VisibleForTesting
    protected SSLConnectionTestUtil(String host, int port, Socket overriddenSocket, OutputStreamWriter testOutputStreamWriter, InputStreamReader testInputStreamReader) {
        this.overriddenSocket = overriddenSocket;
        this.testOutputStreamWriter = testOutputStreamWriter;
        this.testInputStreamReader = testInputStreamReader;
        this.host = host;
        this.port = port;
        this.esPingReplyReceived = false;
        this.dualSSLProbeReplyReceived = false;
    }

    public SSLConnectionTestResult testConnection() {
        if (this.sendDualSSLClientHello()) {
            return SSLConnectionTestResult.SSL_AVAILABLE;
        }
        if (this.sendESPing()) {
            return SSLConnectionTestResult.SSL_NOT_AVAILABLE;
        }
        return SSLConnectionTestResult.ES_PING_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendDualSSLClientHello() {
        boolean dualSslSupported = false;
        Socket socket = null;
        try {
            int currentChar;
            InputStreamReader inputStreamReader;
            OutputStreamWriter outputStreamWriter;
            if (this.overriddenSocket != null) {
                socket = this.overriddenSocket;
                outputStreamWriter = this.testOutputStreamWriter;
                inputStreamReader = this.testInputStreamReader;
            } else {
                socket = new Socket(this.host, this.port);
                outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8);
                inputStreamReader = new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8);
            }
            socket.setSoTimeout(10000);
            outputStreamWriter.write(DUAL_MODE_CLIENT_HELLO_MSG);
            outputStreamWriter.flush();
            logger.debug("Sent DualSSL Client Hello msg to {}", (Object)this.host);
            StringBuilder sb = new StringBuilder();
            while ((currentChar = inputStreamReader.read()) != -1) {
                sb.append((char)currentChar);
            }
            if (sb.toString().equals(DUAL_MODE_SERVER_HELLO_MSG)) {
                logger.debug("Received DualSSL Server Hello msg from {}", (Object)this.host);
                dualSslSupported = true;
            }
        }
        catch (IOException e) {
            logger.debug("DualSSL client check failed for {}, exception {}", (Object)this.host, (Object)e.getMessage());
        }
        finally {
            logger.debug("Closing DualSSL check client socket for {}", (Object)this.host);
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.error("Exception occurred while closing DualSSL check client socket for {}. Exception: {}", (Object)this.host, (Object)e.getMessage());
                }
            }
        }
        logger.debug("dualSslClient check with server {}, server supports ssl = {}", (Object)this.host, (Object)dualSslSupported);
        return dualSslSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendESPing() {
        boolean pingSucceeded;
        block14: {
            pingSucceeded = false;
            Socket socket = null;
            try {
                int currentByte;
                int byteBufIndex;
                socket = this.overriddenSocket != null ? this.overriddenSocket : new Socket(this.host, this.port);
                socket.setSoTimeout(10000);
                OutputStream outputStream = socket.getOutputStream();
                InputStream inputStream = socket.getInputStream();
                logger.debug("Sending ES Ping to {}", (Object)this.host);
                outputStream.write(ES_PING_MSG);
                outputStream.flush();
                byte[] response = new byte[6];
                for (byteBufIndex = 0; byteBufIndex < 6 && (currentByte = inputStream.read()) != -1; ++byteBufIndex) {
                    response[byteBufIndex] = (byte)currentByte;
                }
                if (byteBufIndex != 6) break block14;
                logger.debug("Received reply for ES Ping. from {}", (Object)this.host);
                pingSucceeded = true;
                for (int i = 0; i < 6; ++i) {
                    if (response[i] == ES_PING_MSG[i]) continue;
                    logger.error("Received unexpected byte in ES Ping reply from {}", (Object)this.host);
                    pingSucceeded = false;
                    break;
                }
            }
            catch (IOException ex) {
                logger.error("ES Ping failed for {}, exception: {}", (Object)this.host, (Object)ex.getMessage());
            }
            finally {
                logger.debug("Closing ES Ping client socket for connection to {}", (Object)this.host);
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        logger.error("Exception occurred while closing socket for {}. Exception: {}", (Object)this.host, (Object)e.getMessage());
                    }
                }
            }
        }
        logger.debug("ES Ping check to server {} result = {}", (Object)this.host, (Object)pingSucceeded);
        return pingSucceeded;
    }
}

