/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.util;

import com.amazon.opendistroforelasticsearch.security.ssl.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeystoreProps {
    private final String filePath;
    private final String type;
    private final char[] password;

    public KeystoreProps(String filePath, String type, String password) {
        this.filePath = filePath;
        this.type = type;
        this.password = Utils.toCharArray(password);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getType() {
        return this.type;
    }

    public char[] getPassword() {
        return this.password;
    }

    public KeyStore loadKeystore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore ts = KeyStore.getInstance(this.type);
        ts.load(new FileInputStream(new File(this.filePath)), this.password);
        return ts;
    }
}

