/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.util;

import com.amazon.opendistroforelasticsearch.security.ssl.util.KeystoreProps;
import com.amazon.opendistroforelasticsearch.security.ssl.util.SSLCertificateHelper;
import com.amazon.opendistroforelasticsearch.security.ssl.util.Utils;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.ArrayUtils;
import org.elasticsearch.ElasticsearchException;

public class CertFromKeystore {
    private final KeystoreProps keystoreProps;
    private final String serverKeystoreAlias;
    private final String clientKeystoreAlias;
    private PrivateKey serverKey;
    private X509Certificate[] serverCert;
    private final char[] serverKeyPassword;
    private PrivateKey clientKey;
    private X509Certificate[] clientCert;
    private final char[] clientKeyPassword;
    private X509Certificate[] loadedCerts;

    public CertFromKeystore(KeystoreProps keystoreProps, String keystoreAlias, String keyPassword) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException {
        this.keystoreProps = keystoreProps;
        KeyStore ks = keystoreProps.loadKeystore();
        this.serverKeystoreAlias = keystoreAlias;
        this.serverKeyPassword = Utils.toCharArray(keyPassword);
        this.serverCert = SSLCertificateHelper.exportServerCertChain(ks, this.serverKeystoreAlias);
        this.serverKey = SSLCertificateHelper.exportDecryptedKey(ks, this.serverKeystoreAlias, this.serverKeyPassword);
        this.clientKeystoreAlias = keystoreAlias;
        this.clientKeyPassword = this.serverKeyPassword;
        this.clientCert = this.serverCert;
        this.clientKey = this.serverKey;
        this.loadedCerts = this.serverCert;
        this.validate();
    }

    public CertFromKeystore(KeystoreProps keystoreProps, String serverKeystoreAlias, String clientKeystoreAlias, String serverKeyPassword, String clientKeyPassword) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException {
        this.keystoreProps = keystoreProps;
        KeyStore ks = keystoreProps.loadKeystore();
        this.serverKeystoreAlias = serverKeystoreAlias;
        this.serverKeyPassword = Utils.toCharArray(serverKeyPassword);
        this.serverCert = SSLCertificateHelper.exportServerCertChain(ks, serverKeystoreAlias);
        this.serverKey = SSLCertificateHelper.exportDecryptedKey(ks, serverKeystoreAlias, this.serverKeyPassword);
        this.clientKeystoreAlias = clientKeystoreAlias;
        this.clientKeyPassword = Utils.toCharArray(clientKeyPassword);
        this.clientCert = SSLCertificateHelper.exportServerCertChain(ks, clientKeystoreAlias);
        this.clientKey = SSLCertificateHelper.exportDecryptedKey(ks, clientKeystoreAlias, this.clientKeyPassword);
        this.loadedCerts = (X509Certificate[])ArrayUtils.addAll((Object[])this.serverCert, (Object[])this.clientCert);
        this.validate();
    }

    private void validate() {
        if (this.serverKey == null) {
            throw new ElasticsearchException("No key found in " + this.keystoreProps.getFilePath() + " with alias " + this.serverKeystoreAlias, new Object[0]);
        }
        if (this.serverCert == null || this.serverCert.length == 0) {
            throw new ElasticsearchException("No certificates found in " + this.keystoreProps.getFilePath() + " with alias " + this.serverKeystoreAlias, new Object[0]);
        }
        if (this.clientKey == null) {
            throw new ElasticsearchException("No key found in " + this.keystoreProps.getFilePath() + " with alias " + this.clientKeystoreAlias, new Object[0]);
        }
        if (this.clientCert == null || this.clientCert.length == 0) {
            throw new ElasticsearchException("No certificates found in " + this.keystoreProps.getFilePath() + " with alias " + this.clientKeystoreAlias, new Object[0]);
        }
    }

    public X509Certificate[] getCerts() {
        return this.loadedCerts;
    }

    public PrivateKey getServerKey() {
        return this.serverKey;
    }

    public X509Certificate[] getServerCert() {
        return this.serverCert;
    }

    public PrivateKey getClientKey() {
        return this.clientKey;
    }

    public X509Certificate[] getClientCert() {
        return this.clientCert;
    }
}

