/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.transport;

import com.amazon.opendistroforelasticsearch.security.ssl.OpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.ssl.SslExceptionHandler;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.DualModeSSLHandler;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.OpenDistroSSLConfig;
import com.amazon.opendistroforelasticsearch.security.ssl.util.SSLConnectionTestResult;
import com.amazon.opendistroforelasticsearch.security.ssl.util.SSLConnectionTestUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SharedGroupFactory;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;

public class OpenDistroSecuritySSLNettyTransport
extends Netty4Transport {
    private static final Logger logger = LogManager.getLogger(OpenDistroSecuritySSLNettyTransport.class);
    private final OpenDistroSecurityKeyStore odsks;
    private final SslExceptionHandler errorHandler;
    private final OpenDistroSSLConfig openDistroSSLConfig;

    public OpenDistroSecuritySSLNettyTransport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, OpenDistroSecurityKeyStore odsks, SslExceptionHandler errorHandler, SharedGroupFactory sharedGroupFactory, OpenDistroSSLConfig openDistroSSLConfig) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, sharedGroupFactory);
        this.odsks = odsks;
        this.errorHandler = errorHandler;
        this.openDistroSSLConfig = openDistroSSLConfig;
    }

    public void onException(TcpChannel channel, Exception e) {
        Throwable cause = e;
        if (e instanceof DecoderException && e != null) {
            cause = e.getCause();
        }
        this.errorHandler.logError(cause, false);
        logger.error("Exception during establishing a SSL connection: " + cause, cause);
        super.onException(channel, e);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new SSLServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new SSLClientChannelInitializer(node);
    }

    protected class SSLClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;
        private final DiscoveryNode node;
        private SSLConnectionTestResult connectionTestResult;

        public SSLClientChannelInitializer(DiscoveryNode node) {
            super((Netty4Transport)OpenDistroSecuritySSLNettyTransport.this);
            this.node = node;
            this.hostnameVerificationEnabled = OpenDistroSecuritySSLNettyTransport.this.settings.getAsBoolean("opendistro_security.ssl.transport.enforce_hostname_verification", Boolean.valueOf(true));
            this.hostnameVerificationResovleHostName = OpenDistroSecuritySSLNettyTransport.this.settings.getAsBoolean("opendistro_security.ssl.transport.resolve_hostname", Boolean.valueOf(true));
            this.connectionTestResult = SSLConnectionTestResult.SSL_AVAILABLE;
            if (OpenDistroSecuritySSLNettyTransport.this.openDistroSSLConfig.isDualModeEnabled()) {
                SSLConnectionTestUtil sslConnectionTestUtil = new SSLConnectionTestUtil(node.getAddress().getAddress(), node.getAddress().getPort());
                this.connectionTestResult = AccessController.doPrivileged(sslConnectionTestUtil::testConnection);
            }
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (this.connectionTestResult == SSLConnectionTestResult.ES_PING_FAILED) {
                logger.error("SSL dual mode is enabled but dual mode handshake and ES ping has failed during client connection setup, closing channel");
                ch.close();
                return;
            }
            if (this.connectionTestResult == SSLConnectionTestResult.SSL_AVAILABLE) {
                logger.debug("Connection to {} needs to be ssl, adding ssl handler to the client channel ", (Object)this.node.getHostName());
                ch.pipeline().addFirst("client_ssl_handler", (ChannelHandler)new ClientSSLHandler(OpenDistroSecuritySSLNettyTransport.this.odsks, this.hostnameVerificationEnabled, this.hostnameVerificationResovleHostName, OpenDistroSecuritySSLNettyTransport.this.errorHandler));
            } else {
                logger.debug("Connection to {} needs to be non ssl", (Object)this.node.getHostName());
            }
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            OpenDistroSecuritySSLNettyTransport.this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected static class ClientSSLHandler
    extends ChannelOutboundHandlerAdapter {
        private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
        private final OpenDistroSecurityKeyStore odsks;
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;
        private final SslExceptionHandler errorHandler;

        private ClientSSLHandler(OpenDistroSecurityKeyStore odsks, boolean hostnameVerificationEnabled, boolean hostnameVerificationResovleHostName, SslExceptionHandler errorHandler) {
            this.odsks = odsks;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.hostnameVerificationResovleHostName = hostnameVerificationResovleHostName;
            this.errorHandler = errorHandler;
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine engine = null;
            try {
                if (this.hostnameVerificationEnabled) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                    String hostname = null;
                    hostname = this.hostnameVerificationResovleHostName ? inetSocketAddress.getHostName() : inetSocketAddress.getHostString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Hostname of peer is {} ({}/{}) with hostnameVerificationResovleHostName: {}", (Object)hostname, (Object)inetSocketAddress.getHostName(), (Object)inetSocketAddress.getHostString(), (Object)this.hostnameVerificationResovleHostName);
                    }
                    engine = this.odsks.createClientTransportSSLEngine(hostname, inetSocketAddress.getPort());
                } else {
                    engine = this.odsks.createClientTransportSSLEngine(null, -1);
                }
            }
            catch (SSLException e) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
            SslHandler sslHandler = new SslHandler(engine);
            ctx.pipeline().replace((ChannelHandler)this, "ssl_client", (ChannelHandler)sslHandler);
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }

    protected class SSLServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        public SSLServerChannelInitializer(String name) {
            super((Netty4Transport)OpenDistroSecuritySSLNettyTransport.this, name);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            boolean dualModeEnabled = OpenDistroSecuritySSLNettyTransport.this.openDistroSSLConfig.isDualModeEnabled();
            if (dualModeEnabled) {
                logger.info("SSL Dual mode enabled, using port unification handler");
                DualModeSSLHandler portUnificationHandler = new DualModeSSLHandler(OpenDistroSecuritySSLNettyTransport.this.odsks);
                ch.pipeline().addFirst("port_unification_handler", (ChannelHandler)portUnificationHandler);
            } else {
                SslHandler sslHandler = new SslHandler(OpenDistroSecuritySSLNettyTransport.this.odsks.createServerTransportSSLEngine());
                ch.pipeline().addFirst("ssl_server", (ChannelHandler)sslHandler);
            }
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            OpenDistroSecuritySSLNettyTransport.this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

