/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class OpenDistroSSLConfig {
    public static final Setting<Boolean> SSL_DUAL_MODE_SETTING = Setting.boolSetting((String)"opendistro_security_config.ssl_dual_mode_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final Logger logger = LogManager.getLogger(OpenDistroSSLConfig.class);
    private final boolean sslOnly;
    private volatile boolean dualModeEnabled;

    public OpenDistroSSLConfig(boolean sslOnly, boolean dualModeEnabled) {
        this.sslOnly = sslOnly;
        this.dualModeEnabled = dualModeEnabled;
        if (this.dualModeEnabled && !this.sslOnly) {
            logger.warn("opendistro_security_config.ssl_dual_mode_enabled is enabled but opendistro_security.ssl_only mode is disabled. SSL Dual mode is supported only when security plugin is in ssl_only mode");
        }
        logger.info("SSL dual mode is {}", (Object)(this.isDualModeEnabled() ? "enabled" : "disabled"));
    }

    public OpenDistroSSLConfig(Settings settings) {
        this(settings.getAsBoolean("opendistro_security.ssl_only", Boolean.valueOf(false)), settings.getAsBoolean("opendistro_security_config.ssl_dual_mode_enabled", Boolean.valueOf(false)));
    }

    public void registerClusterSettingsChangeListener(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(SSL_DUAL_MODE_SETTING, dualModeEnabledClusterSetting -> {
            logger.info("Detected change in settings, cluster setting for SSL dual mode is {}", (Object)(dualModeEnabledClusterSetting != false ? "enabled" : "disabled"));
            this.setDualModeEnabled((boolean)dualModeEnabledClusterSetting);
        });
    }

    private void setDualModeEnabled(boolean dualModeEnabled) {
        this.dualModeEnabled = dualModeEnabled;
    }

    public boolean isDualModeEnabled() {
        return this.sslOnly && this.dualModeEnabled;
    }

    public boolean isSslOnlyMode() {
        return this.sslOnly;
    }
}

