/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.transport;

import com.amazon.opendistroforelasticsearch.security.ssl.OpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.ssl.util.TLSUtil;
import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DualModeSSLHandler
extends ByteToMessageDecoder {
    private static final Logger logger = LogManager.getLogger(DualModeSSLHandler.class);
    private final OpenDistroSecurityKeyStore openDistroSecurityKeyStore;
    private final SslHandler providedSSLHandler;

    public DualModeSSLHandler(OpenDistroSecurityKeyStore openDistroSecurityKeyStore) {
        this(openDistroSecurityKeyStore, null);
    }

    @VisibleForTesting
    protected DualModeSSLHandler(OpenDistroSecurityKeyStore openDistroSecurityKeyStore, SslHandler providedSSLHandler) {
        this.openDistroSecurityKeyStore = openDistroSecurityKeyStore;
        this.providedSSLHandler = providedSSLHandler;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 6) {
            return;
        }
        int offset = in.readerIndex();
        if (in.getCharSequence(offset, 6, StandardCharsets.UTF_8).equals("DUALCM")) {
            logger.debug("Received DualSSL Client Hello message");
            ByteBuf responseBuffer = Unpooled.buffer((int)6);
            responseBuffer.writeCharSequence((CharSequence)"DUALSM", StandardCharsets.UTF_8);
            ctx.writeAndFlush((Object)responseBuffer).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        if (TLSUtil.isTLS(in)) {
            logger.debug("Identified request as SSL request");
            this.enableSsl(ctx);
        } else {
            logger.debug("Identified request as non SSL request, running in HTTP mode as dual mode is enabled");
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private void enableSsl(ChannelHandlerContext ctx) throws SSLException {
        SslHandler sslHandler = this.providedSSLHandler != null ? this.providedSSLHandler : new SslHandler(this.openDistroSecurityKeyStore.createServerTransportSSLEngine());
        ChannelPipeline p = ctx.pipeline();
        p.addAfter("port_unification_handler", "ssl_server", (ChannelHandler)sslHandler);
        p.remove((ChannelHandler)this);
        logger.debug("Removed port unification handler and added SSL handler as incoming request is SSL");
    }
}

