/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.rest;

import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.ssl.OpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.user.User;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class OpenDistroSecuritySSLReloadCertsAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "_opendistro/_security/api/ssl/{certType}/reloadcerts/"));
    private final Settings settings;
    private final OpenDistroSecurityKeyStore odsks;
    private final ThreadContext threadContext;
    private final AdminDNs adminDns;

    public OpenDistroSecuritySSLReloadCertsAction(Settings settings, RestController restController, OpenDistroSecurityKeyStore odsks, ThreadPool threadPool, AdminDNs adminDns) {
        this.settings = settings;
        this.odsks = odsks;
        this.adminDns = adminDns;
        this.threadContext = threadPool.getThreadContext();
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final String certType;
            {
                this.certType = request.param("certType").toLowerCase().trim();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                BytesRestResponse response = null;
                User user = (User)OpenDistroSecuritySSLReloadCertsAction.this.threadContext.getTransient("_opendistro_security_user");
                if (user == null || !OpenDistroSecuritySSLReloadCertsAction.this.adminDns.isAdmin(user)) {
                    response = new BytesRestResponse(RestStatus.FORBIDDEN, "");
                } else {
                    try {
                        builder.startObject();
                        if (OpenDistroSecuritySSLReloadCertsAction.this.odsks != null) {
                            switch (this.certType) {
                                case "http": {
                                    OpenDistroSecuritySSLReloadCertsAction.this.odsks.initHttpSSLConfig();
                                    builder.field("message", "updated http certs");
                                    builder.endObject();
                                    response = new BytesRestResponse(RestStatus.OK, builder);
                                    break;
                                }
                                case "transport": {
                                    OpenDistroSecuritySSLReloadCertsAction.this.odsks.initTransportSSLConfig();
                                    builder.field("message", "updated transport certs");
                                    builder.endObject();
                                    response = new BytesRestResponse(RestStatus.OK, builder);
                                    break;
                                }
                                default: {
                                    builder.field("message", "invalid uri path, please use /_opendistro/_security/api/ssl/http/reload or /_opendistro/_security/api/ssl/transport/reload");
                                    builder.endObject();
                                    response = new BytesRestResponse(RestStatus.FORBIDDEN, builder);
                                    break;
                                }
                            }
                        } else {
                            builder.field("message", "keystore is not initialized");
                            builder.endObject();
                            response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                        }
                    }
                    catch (Exception e1) {
                        builder = channel.newBuilder();
                        builder.startObject();
                        builder.field("error", e1.toString());
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                    }
                    finally {
                        if (builder != null) {
                            builder.close();
                        }
                    }
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "SSL Cert Reload Action";
    }
}

