/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.rest;

import com.amazon.opendistroforelasticsearch.security.ssl.OpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.amazon.opendistroforelasticsearch.security.ssl.util.SSLRequestHelper;
import io.netty.handler.ssl.OpenSsl;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class OpenDistroSecuritySSLInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/sslinfo"));
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final OpenDistroSecurityKeyStore odsks;
    final PrincipalExtractor principalExtractor;
    private final Path configPath;
    private final Settings settings;

    public OpenDistroSecuritySSLInfoAction(Settings settings, Path configPath, RestController controller, OpenDistroSecurityKeyStore odsks, PrincipalExtractor principalExtractor) {
        this.settings = settings;
        this.odsks = odsks;
        this.principalExtractor = principalExtractor;
        this.configPath = configPath;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final Boolean showDn;
            {
                this.showDn = request.paramAsBoolean("show_dn", Boolean.FALSE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(OpenDistroSecuritySSLInfoAction.this.settings, OpenDistroSecuritySSLInfoAction.this.configPath, request, OpenDistroSecuritySSLInfoAction.this.principalExtractor);
                    X509Certificate[] certs = sslInfo == null ? null : sslInfo.getX509Certs();
                    X509Certificate[] localCerts = sslInfo == null ? null : sslInfo.getLocalCertificates();
                    builder.startObject();
                    builder.field("principal", sslInfo == null ? null : sslInfo.getPrincipal());
                    builder.field("peer_certificates", certs != null && certs.length > 0 ? certs.length + "" : "0");
                    if (this.showDn == Boolean.TRUE) {
                        builder.field("peer_certificates_list", certs == null ? null : (Iterable)Arrays.stream(certs).map(c -> c.getSubjectDN().getName()).collect(Collectors.toList()));
                        builder.field("local_certificates_list", localCerts == null ? null : (Iterable)Arrays.stream(localCerts).map(c -> c.getSubjectDN().getName()).collect(Collectors.toList()));
                    }
                    builder.field("ssl_protocol", sslInfo == null ? null : sslInfo.getProtocol());
                    builder.field("ssl_cipher", sslInfo == null ? null : sslInfo.getCipher());
                    builder.field("ssl_openssl_available", OpenSsl.isAvailable());
                    builder.field("ssl_openssl_version", OpenSsl.version());
                    builder.field("ssl_openssl_version_string", OpenSsl.versionString());
                    Throwable openSslUnavailCause = OpenSsl.unavailabilityCause();
                    builder.field("ssl_openssl_non_available_cause", openSslUnavailCause == null ? "" : openSslUnavailCause.toString());
                    builder.field("ssl_openssl_supports_key_manager_factory", OpenSsl.supportsKeyManagerFactory());
                    builder.field("ssl_openssl_supports_hostname_validation", OpenSsl.supportsHostnameValidation());
                    builder.field("ssl_provider_http", OpenDistroSecuritySSLInfoAction.this.odsks.getHTTPProviderName());
                    builder.field("ssl_provider_transport_server", OpenDistroSecuritySSLInfoAction.this.odsks.getTransportServerProviderName());
                    builder.field("ssl_provider_transport_client", OpenDistroSecuritySSLInfoAction.this.odsks.getTransportClientProviderName());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Open Distro Security SSL Info";
    }

    static /* synthetic */ Logger access$300(OpenDistroSecuritySSLInfoAction x0) {
        return x0.log;
    }
}

