/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.rest;

import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.ssl.OpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class OpenDistroSecuritySSLCertsInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/ssl/certs"));
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Settings settings;
    private OpenDistroSecurityKeyStore odsks;
    private AdminDNs adminDns;
    private ThreadContext threadContext;

    public OpenDistroSecuritySSLCertsInfoAction(Settings settings, RestController restController, OpenDistroSecurityKeyStore odsks, ThreadPool threadPool, AdminDNs adminDns) {
        this.settings = settings;
        this.odsks = odsks;
        this.adminDns = adminDns;
        this.threadContext = threadPool.getThreadContext();
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                BytesRestResponse response = null;
                User user = (User)OpenDistroSecuritySSLCertsInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                if (user == null || !OpenDistroSecuritySSLCertsInfoAction.this.adminDns.isAdmin(user)) {
                    response = new BytesRestResponse(RestStatus.FORBIDDEN, builder);
                } else {
                    try {
                        if (OpenDistroSecuritySSLCertsInfoAction.this.odsks != null) {
                            builder.startObject();
                            builder.field("http_certificates_list", this.generateCertDetailList(OpenDistroSecuritySSLCertsInfoAction.this.odsks.getHttpCerts()));
                            builder.field("transport_certificates_list", this.generateCertDetailList(OpenDistroSecuritySSLCertsInfoAction.this.odsks.getTransportCerts()));
                            builder.endObject();
                            response = new BytesRestResponse(RestStatus.OK, builder);
                        } else {
                            builder.startObject();
                            builder.field("message", "keystore is not initialized");
                            builder.endObject();
                            response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                        }
                    }
                    catch (Exception e1) {
                        OpenDistroSecuritySSLCertsInfoAction.this.log.error("Error handle request ", (Throwable)e1);
                        builder = channel.newBuilder();
                        builder.startObject();
                        builder.field("error", e1.toString());
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                    }
                    finally {
                        if (builder != null) {
                            builder.close();
                        }
                    }
                }
                channel.sendResponse((RestResponse)response);
            }

            private List<Map<String, String>> generateCertDetailList(X509Certificate[] certs) {
                if (certs == null) {
                    return null;
                }
                return Arrays.stream(certs).map(cert -> {
                    String issuerDn = cert != null && cert.getIssuerX500Principal() != null ? cert.getIssuerX500Principal().getName() : "";
                    String subjectDn = cert != null && cert.getSubjectX500Principal() != null ? cert.getSubjectX500Principal().getName() : "";
                    String san = "";
                    try {
                        san = cert != null && cert.getSubjectAlternativeNames() != null ? cert.getSubjectAlternativeNames().toString() : "";
                    }
                    catch (CertificateParsingException e) {
                        OpenDistroSecuritySSLCertsInfoAction.this.log.error("Issue parsing SubjectAlternativeName:", (Throwable)e);
                    }
                    String notBefore = cert != null && cert.getNotBefore() != null ? cert.getNotBefore().toInstant().toString() : "";
                    String notAfter = cert != null && cert.getNotAfter() != null ? cert.getNotAfter().toInstant().toString() : "";
                    return ImmutableMap.builder().put((Object)"issuer_dn", (Object)issuerDn).put((Object)"subject_dn", (Object)subjectDn).put((Object)"san", (Object)san).put((Object)"not_before", (Object)notBefore).put((Object)"not_after", (Object)notAfter).build();
                }).collect(Collectors.toList());
            }
        };
    }

    public String getName() {
        return "SSL Certificate Information Action";
    }
}

