/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl.http.netty;

import com.amazon.opendistroforelasticsearch.security.ssl.OpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.ssl.SslExceptionHandler;
import com.amazon.opendistroforelasticsearch.security.ssl.http.netty.ValidatingDispatcher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SharedGroupFactory;

public class OpenDistroSecuritySSLNettyHttpServerTransport
extends Netty4HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(OpenDistroSecuritySSLNettyHttpServerTransport.class);
    private final OpenDistroSecurityKeyStore odsks;
    private final SslExceptionHandler errorHandler;

    public OpenDistroSecuritySSLNettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, OpenDistroSecurityKeyStore odsks, NamedXContentRegistry namedXContentRegistry, ValidatingDispatcher dispatcher, SslExceptionHandler errorHandler, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory) {
        super(settings, networkService, bigArrays, threadPool, namedXContentRegistry, (HttpServerTransport.Dispatcher)dispatcher, clusterSettings, sharedGroupFactory);
        this.odsks = odsks;
        this.errorHandler = errorHandler;
    }

    public ChannelHandler configureServerChannelHandler() {
        return new SSLHttpChannelHandler(this, this.handlingSettings, this.odsks);
    }

    public void onException(HttpChannel channel, Exception cause0) {
        Throwable cause = cause0;
        if (cause0 instanceof DecoderException && cause0 != null) {
            cause = cause0.getCause();
        }
        this.errorHandler.logError(cause, true);
        logger.error("Exception during establishing a SSL connection: " + cause, cause);
        super.onException(channel, cause0);
    }

    protected class SSLHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected SSLHttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings, OpenDistroSecurityKeyStore odsks) {
            super(transport, handlingSettings);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SslHandler sslHandler = new SslHandler(OpenDistroSecuritySSLNettyHttpServerTransport.this.odsks.createHTTPSSLEngine());
            ch.pipeline().addFirst("ssl_http", (ChannelHandler)sslHandler);
        }
    }
}

