/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.ssl;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.NonValidatingObjectMapper;
import com.amazon.opendistroforelasticsearch.security.ssl.DefaultOpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.ssl.ExternalOpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.ssl.OpenDistroSecurityKeyStore;
import com.amazon.opendistroforelasticsearch.security.ssl.SslExceptionHandler;
import com.amazon.opendistroforelasticsearch.security.ssl.http.netty.OpenDistroSecuritySSLNettyHttpServerTransport;
import com.amazon.opendistroforelasticsearch.security.ssl.http.netty.ValidatingDispatcher;
import com.amazon.opendistroforelasticsearch.security.ssl.rest.OpenDistroSecuritySSLInfoAction;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.DefaultPrincipalExtractor;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.OpenDistroSSLConfig;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.OpenDistroSecuritySSLNettyTransport;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.OpenDistroSecuritySSLTransportInterceptor;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.fasterxml.jackson.databind.InjectableValues;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SharedGroupFactory;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.watcher.ResourceWatcherService;

public class OpenDistroSecuritySSLPlugin
extends Plugin
implements SystemIndexPlugin,
NetworkPlugin {
    private static boolean USE_NETTY_DEFAULT_ALLOCATOR = Booleans.parseBoolean((String)System.getProperty("es.unsafe.use_netty_default_allocator"), (boolean)false);
    public static final boolean OPENSSL_SUPPORTED = PlatformDependent.javaVersion() < 12 && USE_NETTY_DEFAULT_ALLOCATOR;
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected static final String CLIENT_TYPE = "client.type";
    protected final boolean client;
    protected final boolean httpSSLEnabled;
    protected final boolean transportSSLEnabled;
    protected final boolean extendedKeyUsageEnabled;
    protected final Settings settings;
    protected final SharedGroupFactory sharedGroupFactory;
    protected final OpenDistroSecurityKeyStore odsks;
    protected PrincipalExtractor principalExtractor;
    protected final Path configPath;
    private static final SslExceptionHandler NOOP_SSL_EXCEPTION_HANDLER = new SslExceptionHandler(){};
    protected final OpenDistroSSLConfig openDistroSSLConfig;

    protected OpenDistroSecuritySSLPlugin(Settings settings, Path configPath, boolean disabled) {
        SecurityManager sm;
        if (disabled) {
            this.settings = null;
            this.sharedGroupFactory = null;
            this.client = false;
            this.httpSSLEnabled = false;
            this.transportSSLEnabled = false;
            this.extendedKeyUsageEnabled = false;
            this.odsks = null;
            this.configPath = null;
            this.openDistroSSLConfig = new OpenDistroSSLConfig(false, false);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("es.set.netty.runtime.available.processors", "false");
                    return null;
                }
            });
            return;
        }
        this.openDistroSSLConfig = new OpenDistroSSLConfig(settings);
        this.configPath = configPath;
        if (this.configPath != null) {
            this.log.info("ES Config path is " + this.configPath.toAbsolutePath());
        } else {
            this.log.info("ES Config path is not set");
        }
        boolean allowClientInitiatedRenegotiation = settings.getAsBoolean("opendistro_security.ssl.allow_client_initiated_renegotiation", Boolean.valueOf(false));
        boolean rejectClientInitiatedRenegotiation = Boolean.parseBoolean(System.getProperty("jdk.tls.rejectClientInitiatedRenegotiation"));
        if (allowClientInitiatedRenegotiation && !rejectClientInitiatedRenegotiation) {
            String renegoMsg = "Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.";
            this.log.warn("Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.");
            System.out.println("Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.");
            System.err.println("Client side initiated TLS renegotiation enabled. This can open a vulnerablity for DoS attacks through client side initiated TLS renegotiation.");
        } else if (!rejectClientInitiatedRenegotiation) {
            sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("jdk.tls.rejectClientInitiatedRenegotiation", "true");
                    return null;
                }
            });
            this.log.debug("Client side initiated TLS renegotiation forcibly disabled. This can prevent DoS attacks. (jdk.tls.rejectClientInitiatedRenegotiation set to true).");
        } else {
            this.log.debug("Client side initiated TLS renegotiation already disabled.");
        }
        sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("es.set.netty.runtime.available.processors", "false");
                PlatformDependent.newFixedMpscQueue((int)1);
                OpenSsl.isAvailable();
                return null;
            }
        });
        this.settings = settings;
        this.sharedGroupFactory = new SharedGroupFactory(settings);
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(Settings.class, (Object)settings);
        DefaultObjectMapper.inject(injectableValues);
        NonValidatingObjectMapper.inject(injectableValues);
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE));
        this.httpSSLEnabled = settings.getAsBoolean("opendistro_security.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("opendistro_security.ssl.transport.enabled", Boolean.valueOf(true));
        this.extendedKeyUsageEnabled = settings.getAsBoolean("opendistro_security.ssl.transport.extended_key_usage_enabled", Boolean.valueOf(false));
        if (!this.httpSSLEnabled && !this.transportSSLEnabled) {
            this.log.error("SSL not activated for http and/or transport.");
            System.out.println("SSL not activated for http and/or transport.");
            System.err.println("SSL not activated for http and/or transport.");
        }
        this.odsks = ExternalOpenDistroSecurityKeyStore.hasExternalSslContext(settings) ? new ExternalOpenDistroSecurityKeyStore(settings) : new DefaultOpenDistroSecurityKeyStore(settings, configPath);
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings) {
        if (!this.client && this.httpSSLEnabled) {
            ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings, this.configPath, NOOP_SSL_EXCEPTION_HANDLER);
            OpenDistroSecuritySSLNettyHttpServerTransport sgsnht = new OpenDistroSecuritySSLNettyHttpServerTransport(settings, networkService, bigArrays, threadPool, this.odsks, xContentRegistry, validatingDispatcher, NOOP_SSL_EXCEPTION_HANDLER, clusterSettings, this.sharedGroupFactory);
            return Collections.singletonMap("com.amazon.opendistroforelasticsearch.security.ssl.http.netty.OpenDistroSecuritySSLNettyHttpServerTransport", () -> sgsnht);
        }
        return Collections.emptyMap();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>(1);
        if (!this.client) {
            handlers.add((RestHandler)new OpenDistroSecuritySSLInfoAction(settings, this.configPath, restController, this.odsks, Objects.requireNonNull(this.principalExtractor)));
        }
        return handlers;
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (this.transportSSLEnabled && !this.client) {
            interceptors.add(new OpenDistroSecuritySSLTransportInterceptor(this.settings, null, null, NOOP_SSL_EXCEPTION_HANDLER));
        }
        return interceptors;
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (this.transportSSLEnabled) {
            transports.put("com.amazon.opendistroforelasticsearch.security.ssl.http.netty.OpenDistroSecuritySSLNettyTransport", () -> new OpenDistroSecuritySSLNettyTransport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.odsks, NOOP_SSL_EXCEPTION_HANDLER, this.sharedGroupFactory, this.openDistroSSLConfig));
        }
        return transports;
    }

    public Collection<Object> createComponents(Client localClient, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        ArrayList<Object> components = new ArrayList<Object>(1);
        if (this.client) {
            return components;
        }
        String principalExtractorClass = this.settings.get("opendistro_security.ssl.transport.principal_extractor_class", null);
        if (principalExtractorClass == null) {
            this.principalExtractor = new DefaultPrincipalExtractor();
        } else {
            try {
                this.log.debug("Try to load and instantiate '{}'", (Object)principalExtractorClass);
                Class<?> principalExtractorClazz = Class.forName(principalExtractorClass);
                this.principalExtractor = (PrincipalExtractor)principalExtractorClazz.newInstance();
            }
            catch (Exception e) {
                this.log.error("Unable to load '{}' due to", (Object)principalExtractorClass, (Object)e);
                throw new ElasticsearchException((Throwable)e);
            }
        }
        components.add(this.principalExtractor);
        return components;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.clientauth_mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.keystore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.keystore_keypassword", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.truststore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.http.enable_openssl_if_available", (boolean)OPENSSL_SUPPORTED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.http.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.transport.enable_openssl_if_available", (boolean)OPENSSL_SUPPORTED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.transport.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.transport.enforce_hostname_verification", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.transport.resolve_hostname", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.keystore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.truststore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"opendistro_security.ssl.http.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"opendistro_security.ssl.http.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"opendistro_security.ssl.transport.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"opendistro_security.ssl.transport.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.client.external_context_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.principal_extractor_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.transport.extended_key_usage_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        if (this.extendedKeyUsageEnabled) {
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.server.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.server.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.server.keystore_keypassword", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.client.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.client.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.client.keystore_keypassword", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.server.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.server.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.server.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.server.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.client.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.client.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.client.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.client.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        } else {
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.keystore_keypassword", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"opendistro_security.ssl.transport.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        }
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"opendistro_security.ssl.http.crl.file_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.http.crl.validate", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.http.crl.prefer_crlfile_over_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.http.crl.check_only_end_entities", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.http.crl.disable_crldp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"opendistro_security.ssl.http.crl.disable_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.longSetting((String)"opendistro_security.ssl.http.crl.validation_date", (long)-1L, (long)-1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        return settings;
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        if (!this.client && this.httpSSLEnabled) {
            if (this.settings.get("http.compression") == null) {
                builder.put("http.compression", false);
                this.log.info("Disabled https compression by default to mitigate BREACH attacks. You can enable it by setting 'http.compression: true' in elasticsearch.yml");
            }
            builder.put("http.type", "com.amazon.opendistroforelasticsearch.security.ssl.http.netty.OpenDistroSecuritySSLNettyHttpServerTransport");
        }
        if (this.transportSSLEnabled) {
            builder.put("transport.type", "com.amazon.opendistroforelasticsearch.security.ssl.http.netty.OpenDistroSecuritySSLNettyTransport");
        }
        return builder.build();
    }

    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        settingsFilter.add("opendistro_security.*");
        return settingsFilter;
    }
}

