/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.securityconf.impl;

import com.amazon.opendistroforelasticsearch.security.securityconf.impl.HttpRequestMethods;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class WhitelistingSettings {
    private boolean enabled;
    private Map<String, List<HttpRequestMethods>> requests;

    public WhitelistingSettings() {
        this.enabled = false;
        this.requests = Collections.emptyMap();
    }

    public WhitelistingSettings(WhitelistingSettings whitelistingSettings) {
        this.enabled = whitelistingSettings.getEnabled();
        this.requests = whitelistingSettings.getRequests();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, List<HttpRequestMethods>> getRequests() {
        return this.requests == null ? Collections.emptyMap() : this.requests;
    }

    public void setRequests(Map<String, List<HttpRequestMethods>> requests) {
        this.requests = requests;
    }

    public String toString() {
        return "WhitelistingSetting [enabled=" + this.enabled + ", requests=" + this.requests + ']';
    }

    private boolean requestIsWhitelisted(RestRequest request) {
        String path = request.path();
        String pathWithoutTrailingSlash = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        String pathWithTrailingSlash = pathWithoutTrailingSlash + '/';
        if (this.requests.containsKey(pathWithoutTrailingSlash) && this.requests.get(pathWithoutTrailingSlash).contains((Object)HttpRequestMethods.valueOf(request.method().toString()))) {
            return true;
        }
        return this.requests.containsKey(pathWithTrailingSlash) && this.requests.get(pathWithTrailingSlash).contains((Object)HttpRequestMethods.valueOf(request.method().toString()));
    }

    public boolean checkRequestIsAllowed(RestRequest request, RestChannel channel, NodeClient client) throws IOException {
        if (this.enabled && !this.requestIsWhitelisted(request)) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, channel.newErrorBuilder().startObject().field("error", request.method() + " " + request.path() + " API not whitelisted").field("status", (Object)RestStatus.FORBIDDEN).endObject()));
            return false;
        }
        return true;
    }
}

