/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.securityconf;

import com.amazon.opendistroforelasticsearch.security.resolver.IndexResolverReplacer;
import com.amazon.opendistroforelasticsearch.security.securityconf.ConfigModel;
import com.amazon.opendistroforelasticsearch.security.securityconf.DynamicConfigModel;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.ActionGroupsV7;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.RoleMappingsV7;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.RoleV7;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.TenantV7;
import com.amazon.opendistroforelasticsearch.security.support.ConfigConstants;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;

public class ConfigModelV7
extends ConfigModel {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private ConfigConstants.RolesMappingResolution rolesMappingResolution;
    private ActionGroupResolver agr = null;
    private SecurityRoles securityRoles = null;
    private TenantHolder tenantHolder;
    private RoleMappingHolder roleMappingHolder;
    private SecurityDynamicConfiguration<RoleV7> roles;
    private SecurityDynamicConfiguration<TenantV7> tenants;

    public ConfigModelV7(SecurityDynamicConfiguration<RoleV7> roles, SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, SecurityDynamicConfiguration<ActionGroupsV7> actiongroups, SecurityDynamicConfiguration<TenantV7> tenants, DynamicConfigModel dcm, Settings esSettings) {
        this.roles = roles;
        this.tenants = tenants;
        try {
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.valueOf(esSettings.get("opendistro_security.roles_mapping_resolution", ConfigConstants.RolesMappingResolution.MAPPING_ONLY.toString()).toUpperCase());
        }
        catch (Exception e) {
            this.log.error("Cannot apply roles mapping resolution", (Throwable)e);
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.MAPPING_ONLY;
        }
        this.agr = this.reloadActionGroups(actiongroups);
        this.securityRoles = this.reload(roles);
        this.tenantHolder = new TenantHolder(roles, tenants);
        this.roleMappingHolder = new RoleMappingHolder(rolemappings, dcm.getHostsResolverMode());
    }

    @Override
    public Set<String> getAllConfiguredTenantNames() {
        return Collections.unmodifiableSet(this.tenants.getCEntries().keySet());
    }

    @Override
    public SecurityRoles getSecurityRoles() {
        return this.securityRoles;
    }

    private ActionGroupResolver reloadActionGroups(final SecurityDynamicConfiguration<ActionGroupsV7> actionGroups) {
        return new ActionGroupResolver(){

            private Set<String> getGroupMembers(String groupname) {
                if (actionGroups == null) {
                    return Collections.emptySet();
                }
                return Collections.unmodifiableSet(this.resolve(actionGroups, groupname));
            }

            private Set<String> resolve(SecurityDynamicConfiguration<?> actionGroups2, String entry) {
                if (!actionGroups2.getCEntries().containsKey(entry)) {
                    return Collections.emptySet();
                }
                HashSet<String> ret = new HashSet<String>();
                Object actionGroupAsObject = actionGroups2.getCEntries().get(entry);
                if (actionGroupAsObject != null && actionGroupAsObject instanceof List) {
                    for (String perm : (List)actionGroupAsObject) {
                        if (actionGroups2.getCEntries().keySet().contains(perm)) {
                            ret.addAll(this.resolve(actionGroups2, perm));
                            continue;
                        }
                        ret.add(perm);
                    }
                } else if (actionGroupAsObject != null && actionGroupAsObject instanceof ActionGroupsV7) {
                    for (String perm : ((ActionGroupsV7)actionGroupAsObject).getAllowed_actions()) {
                        if (actionGroups2.getCEntries().keySet().contains(perm)) {
                            ret.addAll(this.resolve(actionGroups2, perm));
                            continue;
                        }
                        ret.add(perm);
                    }
                } else {
                    throw new RuntimeException("Unable to handle " + actionGroupAsObject);
                }
                return Collections.unmodifiableSet(ret);
            }

            @Override
            public Set<String> resolvedActions(List<String> actions) {
                HashSet<String> resolvedActions = new HashSet<String>();
                for (String string : actions) {
                    Set<String> groups = this.getGroupMembers(string);
                    if (groups.isEmpty()) {
                        resolvedActions.add(string);
                        continue;
                    }
                    resolvedActions.addAll(groups);
                }
                return Collections.unmodifiableSet(resolvedActions);
            }
        };
    }

    private SecurityRoles reload(SecurityDynamicConfiguration<RoleV7> settings) {
        HashSet<Future> futures = new HashSet<Future>(5000);
        ExecutorService execs = Executors.newFixedThreadPool(10);
        for (final Map.Entry<String, RoleV7> securityRole : settings.getCEntries().entrySet()) {
            Future future = execs.submit(new Callable<SecurityRole>(){

                @Override
                public SecurityRole call() throws Exception {
                    SecurityRole.Builder _securityRole = new SecurityRole.Builder((String)securityRole.getKey());
                    if (securityRole.getValue() == null) {
                        return null;
                    }
                    Set<String> permittedClusterActions = ConfigModelV7.this.agr.resolvedActions(((RoleV7)securityRole.getValue()).getCluster_permissions());
                    _securityRole.addClusterPerms(permittedClusterActions);
                    for (RoleV7.Index permittedAliasesIndex : ((RoleV7)securityRole.getValue()).getIndex_permissions()) {
                        String dls = permittedAliasesIndex.getDls();
                        List<String> fls = permittedAliasesIndex.getFls();
                        List<String> maskedFields = permittedAliasesIndex.getMasked_fields();
                        for (String pat : permittedAliasesIndex.getIndex_patterns()) {
                            IndexPattern _indexPattern = new IndexPattern(pat);
                            _indexPattern.setDlsQuery(dls);
                            _indexPattern.addFlsFields(fls);
                            _indexPattern.addMaskedFields(maskedFields);
                            _indexPattern.addPerm(ConfigModelV7.this.agr.resolvedActions(permittedAliasesIndex.getAllowed_actions()));
                            _securityRole.addIndexPattern(_indexPattern);
                        }
                    }
                    return _securityRole.build();
                }
            });
            futures.add(future);
        }
        execs.shutdown();
        try {
            execs.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Thread interrupted (1) while loading roles");
            return null;
        }
        try {
            SecurityRoles _securityRoles = new SecurityRoles(futures.size());
            for (Future future : futures) {
                _securityRoles.addSecurityRole((SecurityRole)future.get());
            }
            return _securityRoles;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Thread interrupted (2) while loading roles");
            return null;
        }
        catch (ExecutionException e) {
            this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    private static String replaceProperties(String orig, User user) {
        if (user == null || orig == null) {
            return orig;
        }
        orig = orig.replace("${user.name}", user.getName()).replace("${user_name}", user.getName());
        orig = ConfigModelV7.replaceRoles(orig, user);
        for (Map.Entry<String, String> entry : user.getCustomAttributesMap().entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            orig = orig.replace("${" + entry.getKey() + "}", entry.getValue());
            orig = orig.replace("${" + entry.getKey().replace('.', '_') + "}", entry.getValue());
        }
        return orig;
    }

    private static String replaceRoles(String orig, User user) {
        String retVal = orig;
        if (orig.contains("${user.roles}") || orig.contains("${user_roles}")) {
            String commaSeparatedRoles = ConfigModelV7.toQuotedCommaSeparatedString(user.getRoles());
            retVal = orig.replace("${user.roles}", commaSeparatedRoles).replace("${user_roles}", commaSeparatedRoles);
        }
        return retVal;
    }

    private static String toQuotedCommaSeparatedString(Set<String> roles) {
        return Joiner.on((char)',').join(Iterables.transform(roles, s -> new StringBuilder(s.length() + 2).append('\"').append((String)s).append('\"').toString()));
    }

    private static boolean impliesTypePerm(Set<IndexPattern> ipatterns, IndexResolverReplacer.Resolved resolved, User user, String[] requestedActions, IndexNameExpressionResolver resolver, ClusterService cs) {
        Set<String> resolvedRequestedIndices = resolved.getAllIndices();
        IndexMatcherAndPermissions[] indexMatcherAndPermissions = (IndexMatcherAndPermissions[])ipatterns.stream().map(p -> new IndexMatcherAndPermissions(((IndexPattern)p).getResolvedIndexPattern(user, resolver, cs), ((IndexPattern)p).perms)).toArray(IndexMatcherAndPermissions[]::new);
        return resolvedRequestedIndices.stream().allMatch(index -> Arrays.stream(requestedActions).allMatch(action -> Arrays.stream(indexMatcherAndPermissions).anyMatch(ipap -> ipap.matches((String)index, (String)action))));
    }

    @Override
    public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
        return this.tenantHolder.mapTenants(user, roles);
    }

    @Override
    public Set<String> mapSecurityRoles(User user, TransportAddress caller) {
        return this.roleMappingHolder.map(user, caller);
    }

    private class RoleMappingHolder {
        private ListMultimap<String, String> users;
        private ListMultimap<List<WildcardMatcher>, String> abars;
        private ListMultimap<String, String> bars;
        private ListMultimap<String, String> hosts;
        private final String hostResolverMode;
        private List<WildcardMatcher> userMatchers;
        private List<WildcardMatcher> barMatchers;
        private List<WildcardMatcher> hostMatchers;

        private RoleMappingHolder(SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, String hostResolverMode) {
            this.hostResolverMode = hostResolverMode;
            if (ConfigModelV7.this.roles != null) {
                this.users = ArrayListMultimap.create();
                this.abars = ArrayListMultimap.create();
                this.bars = ArrayListMultimap.create();
                this.hosts = ArrayListMultimap.create();
                for (Map.Entry<String, RoleMappingsV7> roleMap : rolemappings.getCEntries().entrySet()) {
                    String roleMapKey = roleMap.getKey();
                    RoleMappingsV7 roleMapValue = roleMap.getValue();
                    for (String u : roleMapValue.getUsers()) {
                        this.users.put((Object)u, (Object)roleMapKey);
                    }
                    HashSet<String> abar = new HashSet<String>(roleMapValue.getAnd_backend_roles());
                    if (!abar.isEmpty()) {
                        this.abars.put(WildcardMatcher.matchers(abar), (Object)roleMapKey);
                    }
                    for (String bar : roleMapValue.getBackend_roles()) {
                        this.bars.put((Object)bar, (Object)roleMapKey);
                    }
                    for (String host : roleMapValue.getHosts()) {
                        this.hosts.put((Object)host, (Object)roleMapKey);
                    }
                }
                this.userMatchers = WildcardMatcher.matchers(this.users.keySet());
                this.barMatchers = WildcardMatcher.matchers(this.bars.keySet());
                this.hostMatchers = WildcardMatcher.matchers(this.hosts.keySet());
            }
        }

        private Set<String> map(User user, TransportAddress caller) {
            if (user == null || this.users == null || this.abars == null || this.bars == null || this.hosts == null) {
                return Collections.emptySet();
            }
            HashSet<String> securityRoles = new HashSet<String>(user.getOpenDistroSecurityRoles());
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BACKENDROLES_ONLY) {
                if (ConfigModelV7.this.log.isDebugEnabled()) {
                    ConfigModelV7.this.log.debug("Pass backendroles from {}", (Object)user);
                }
                securityRoles.addAll(user.getRoles());
            }
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.MAPPING_ONLY) {
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.userMatchers, user.getName())) {
                    securityRoles.addAll(this.users.get((Object)p2));
                }
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.barMatchers, user.getRoles())) {
                    securityRoles.addAll(this.bars.get((Object)p2));
                }
                for (Object patterns : this.abars.keySet()) {
                    if (!patterns.stream().allMatch(p -> p.matchAny(user.getRoles()))) continue;
                    securityRoles.addAll(this.abars.get(patterns));
                }
                if (caller != null) {
                    String ipAddress = caller.getAddress();
                    for (String p3 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, ipAddress)) {
                        securityRoles.addAll(this.hosts.get((Object)p3));
                    }
                    if (caller.address() != null && (this.hostResolverMode.equalsIgnoreCase("ip-hostname") || this.hostResolverMode.equalsIgnoreCase("ip-hostname-lookup"))) {
                        String hostName = caller.address().getHostString();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, hostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                    if (caller.address() != null && this.hostResolverMode.equalsIgnoreCase("ip-hostname-lookup")) {
                        String resolvedHostName = caller.address().getHostName();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, resolvedHostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(securityRoles);
        }
    }

    private class TenantHolder {
        private SetMultimap<String, Tuple<String, Boolean>> tenantsMM = null;

        public TenantHolder(SecurityDynamicConfiguration<RoleV7> roles, final SecurityDynamicConfiguration<TenantV7> definedTenants) {
            HashSet<Future> futures = new HashSet<Future>(roles.getCEntries().size());
            ExecutorService execs = Executors.newFixedThreadPool(10);
            for (final Map.Entry<String, RoleV7> securityRole : roles.getCEntries().entrySet()) {
                if (securityRole.getValue() == null) continue;
                Future future = execs.submit(new Callable<Tuple<String, Set<Tuple<String, Boolean>>>>(){

                    @Override
                    public Tuple<String, Set<Tuple<String, Boolean>>> call() throws Exception {
                        HashSet<Tuple> tuples = new HashSet<Tuple>();
                        List<RoleV7.Tenant> tenants = ((RoleV7)securityRole.getValue()).getTenant_permissions();
                        if (tenants != null) {
                            for (RoleV7.Tenant tenant : tenants) {
                                for (String matchingTenant : WildcardMatcher.from(tenant.getTenant_patterns()).getMatchAny(definedTenants.getCEntries().keySet(), Collectors.toList())) {
                                    tuples.add(new Tuple((Object)matchingTenant, (Object)ConfigModelV7.this.agr.resolvedActions(tenant.getAllowed_actions()).contains("kibana:saved_objects/*/write")));
                                }
                            }
                        }
                        return new Tuple((Object)((String)securityRole.getKey()), tuples);
                    }
                });
                futures.add(future);
            }
            execs.shutdown();
            try {
                execs.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV7.this.log.error("Thread interrupted (1) while loading roles");
                return;
            }
            try {
                SetMultimap tenantsMM_ = MultimapBuilder.SetMultimapBuilder.hashKeys((int)futures.size()).hashSetValues(16).build();
                for (Future future : futures) {
                    Tuple result = (Tuple)future.get();
                    tenantsMM_.putAll((Object)((String)result.v1()), (Iterable)result.v2());
                }
                this.tenantsMM = tenantsMM_;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV7.this.log.error("Thread interrupted (2) while loading roles");
                return;
            }
            catch (ExecutionException e) {
                ConfigModelV7.this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }

        public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
            if (user == null || this.tenantsMM == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(roles.size());
            result.put(user.getName(), true);
            this.tenantsMM.entries().stream().filter(e -> roles.contains(e.getKey())).filter(e -> !user.getName().equals(((Tuple)e.getValue()).v1())).forEach(e -> {
                String tenant = (String)((Tuple)e.getValue()).v1();
                boolean rw = (Boolean)((Tuple)e.getValue()).v2();
                if (rw || !result.containsKey(tenant)) {
                    result.put(tenant, rw);
                }
            });
            if (!result.containsKey("global_tenant") && (roles.contains("kibana_user") || roles.contains("kibana_user") || roles.contains("all_access") || roles.contains("ALL_ACCESS"))) {
                result.put("global_tenant", true);
            }
            return Collections.unmodifiableMap(result);
        }
    }

    private static final class IndexMatcherAndPermissions {
        private WildcardMatcher matcher;
        private WildcardMatcher perms;

        public IndexMatcherAndPermissions(Set<String> patterns, Set<String> perms) {
            this.matcher = WildcardMatcher.from(patterns);
            this.perms = WildcardMatcher.from(perms);
        }

        public boolean matches(String index, String action) {
            return this.matcher.test(index) && this.perms.test(action);
        }
    }

    public static class Tenant {
        private final String tenant;
        private final boolean readWrite;

        private Tenant(String tenant, boolean readWrite) {
            this.tenant = tenant;
            this.readWrite = readWrite;
        }

        public String getTenant() {
            return this.tenant;
        }

        public boolean isReadWrite() {
            return this.readWrite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.readWrite ? 1231 : 1237);
            result = 31 * result + (this.tenant == null ? 0 : this.tenant.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tenant other = (Tenant)obj;
            if (this.readWrite != other.readWrite) {
                return false;
            }
            return !(this.tenant == null ? other.tenant != null : !this.tenant.equals(other.tenant));
        }

        public String toString() {
            return System.lineSeparator() + "                tenant=" + this.tenant + System.lineSeparator() + "                readWrite=" + this.readWrite;
        }
    }

    public static class IndexPattern {
        private final String indexPattern;
        private String dlsQuery;
        private final Set<String> fls = new HashSet<String>();
        private final Set<String> maskedFields = new HashSet<String>();
        private final Set<String> perms = new HashSet<String>();

        public IndexPattern(String indexPattern) {
            this.indexPattern = Objects.requireNonNull(indexPattern);
        }

        public IndexPattern addFlsFields(List<String> flsFields) {
            if (flsFields != null) {
                this.fls.addAll(flsFields);
            }
            return this;
        }

        public IndexPattern addMaskedFields(List<String> maskedFields) {
            if (maskedFields != null) {
                this.maskedFields.addAll(maskedFields);
            }
            return this;
        }

        public IndexPattern addPerm(Set<String> perms) {
            if (perms != null) {
                this.perms.addAll(perms);
            }
            return this;
        }

        public IndexPattern setDlsQuery(String dlsQuery) {
            if (dlsQuery != null) {
                this.dlsQuery = dlsQuery;
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dlsQuery == null ? 0 : this.dlsQuery.hashCode());
            result = 31 * result + (this.fls == null ? 0 : this.fls.hashCode());
            result = 31 * result + (this.maskedFields == null ? 0 : this.maskedFields.hashCode());
            result = 31 * result + (this.indexPattern == null ? 0 : this.indexPattern.hashCode());
            result = 31 * result + (this.perms == null ? 0 : this.perms.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexPattern other = (IndexPattern)obj;
            if (this.dlsQuery == null ? other.dlsQuery != null : !this.dlsQuery.equals(other.dlsQuery)) {
                return false;
            }
            if (this.fls == null ? other.fls != null : !this.fls.equals(other.fls)) {
                return false;
            }
            if (this.maskedFields == null ? other.maskedFields != null : !this.maskedFields.equals(other.maskedFields)) {
                return false;
            }
            if (this.indexPattern == null ? other.indexPattern != null : !this.indexPattern.equals(other.indexPattern)) {
                return false;
            }
            return !(this.perms == null ? other.perms != null : !this.perms.equals(other.perms));
        }

        public String toString() {
            return System.lineSeparator() + "        indexPattern=" + this.indexPattern + System.lineSeparator() + "          dlsQuery=" + this.dlsQuery + System.lineSeparator() + "          fls=" + this.fls + System.lineSeparator() + "          perms=" + this.perms;
        }

        public String getUnresolvedIndexPattern(User user) {
            return ConfigModelV7.replaceProperties(this.indexPattern, user);
        }

        private Set<String> getResolvedIndexPattern(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            String[] aliasesForPermittedPattern;
            String unresolved = this.getUnresolvedIndexPattern(user);
            WildcardMatcher matcher = WildcardMatcher.from(unresolved);
            String[] resolved = null;
            if (!(matcher instanceof WildcardMatcher.Exact) && (aliasesForPermittedPattern = (String[])cs.state().getMetadata().getIndicesLookup().entrySet().stream().filter(e -> ((IndexAbstraction)e.getValue()).getType() == IndexAbstraction.Type.ALIAS).filter(e -> matcher.test((String)e.getKey())).map(e -> (String)e.getKey()).toArray(String[]::new)).length > 0) {
                resolved = resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), aliasesForPermittedPattern);
            }
            if (resolved == null && !unresolved.isEmpty()) {
                resolved = resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), new String[]{unresolved});
            }
            if (resolved == null || resolved.length == 0) {
                return ImmutableSet.of((Object)unresolved);
            }
            return ImmutableSet.builder().addAll(Arrays.asList(resolved)).add((Object)unresolved).build();
        }

        public String getDlsQuery(User user) {
            return ConfigModelV7.replaceProperties(this.dlsQuery, user);
        }

        public Set<String> getFls() {
            return Collections.unmodifiableSet(this.fls);
        }

        public Set<String> getMaskedFields() {
            return Collections.unmodifiableSet(this.maskedFields);
        }

        public WildcardMatcher getPerms() {
            return WildcardMatcher.from(this.perms);
        }
    }

    public static class SecurityRole {
        private final String name;
        private final Set<IndexPattern> ipatterns;
        private final WildcardMatcher clusterPerms;

        private SecurityRole(String name, Set<IndexPattern> ipatterns, WildcardMatcher clusterPerms) {
            this.name = Objects.requireNonNull(name);
            this.ipatterns = ipatterns;
            this.clusterPerms = clusterPerms;
        }

        private boolean impliesClusterPermission(String action) {
            return this.clusterPerms.test(action);
        }

        private Set<String> getAllResolvedPermittedIndices(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet retVal = new HashSet();
            for (IndexPattern p : this.ipatterns) {
                boolean patternMatch = p.getPerms().matchAll(actions);
                if (!patternMatch) continue;
                WildcardMatcher permitted = WildcardMatcher.from(p.getResolvedIndexPattern(user, resolver, cs));
                HashSet res = new HashSet();
                if (!(resolved.isLocalAll() || resolved.getAllIndices().contains("*") || resolved.getAllIndices().contains("_all"))) {
                    resolved.getAllIndices().stream().filter(permitted).forEach(res::add);
                } else {
                    String[] allIndices = cs.state().metadata().getConcreteAllOpenIndices();
                    Arrays.stream(allIndices).filter(permitted).forEach(res::add);
                }
                retVal.addAll(res);
            }
            return Collections.unmodifiableSet(retVal);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clusterPerms == null ? 0 : this.clusterPerms.hashCode());
            result = 31 * result + (this.ipatterns == null ? 0 : this.ipatterns.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityRole other = (SecurityRole)obj;
            if (this.clusterPerms == null ? other.clusterPerms != null : !this.clusterPerms.equals(other.clusterPerms)) {
                return false;
            }
            if (this.ipatterns == null ? other.ipatterns != null : !this.ipatterns.equals(other.ipatterns)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return System.lineSeparator() + "  " + this.name + System.lineSeparator() + "    ipatterns=" + this.ipatterns + System.lineSeparator() + "    clusterPerms=" + this.clusterPerms;
        }

        public Set<IndexPattern> getIpatterns() {
            return Collections.unmodifiableSet(this.ipatterns);
        }

        public String getName() {
            return this.name;
        }

        public static final class Builder {
            private final String name;
            private final Set<String> clusterPerms = new HashSet<String>();
            private final Set<IndexPattern> ipatterns = new HashSet<IndexPattern>();

            public Builder(String name) {
                this.name = Objects.requireNonNull(name);
            }

            public Builder addIndexPattern(IndexPattern indexPattern) {
                this.ipatterns.add(indexPattern);
                return this;
            }

            public Builder addClusterPerms(Collection<String> clusterPerms) {
                if (clusterPerms != null) {
                    this.clusterPerms.addAll(clusterPerms);
                }
                return this;
            }

            public SecurityRole build() {
                return new SecurityRole(this.name, this.ipatterns, WildcardMatcher.from(this.clusterPerms));
            }
        }
    }

    public static class SecurityRoles
    implements com.amazon.opendistroforelasticsearch.security.securityconf.SecurityRoles {
        protected final Logger log = LogManager.getLogger(this.getClass());
        final Set<SecurityRole> roles;

        private SecurityRoles(int roleCount) {
            this.roles = new HashSet<SecurityRole>(roleCount);
        }

        private SecurityRoles addSecurityRole(SecurityRole securityRole) {
            if (securityRole != null) {
                this.roles.add(securityRole);
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityRoles other = (SecurityRoles)obj;
            return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
        }

        public String toString() {
            return "roles=" + this.roles;
        }

        public Set<SecurityRole> getRoles() {
            return Collections.unmodifiableSet(this.roles);
        }

        @Override
        public Set<String> getRoleNames() {
            return this.getRoles().stream().map(r -> r.getName()).collect(Collectors.toSet());
        }

        @Override
        public SecurityRoles filter(Set<String> keep) {
            SecurityRoles retVal = new SecurityRoles(this.roles.size());
            for (SecurityRole sr : this.roles) {
                if (!keep.contains(sr.getName())) continue;
                retVal.addSecurityRole(sr);
            }
            return retVal;
        }

        @Override
        public Map<String, Set<String>> getMaskedFields(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashMap<String, Set<String>> maskedFieldsMap = new HashMap<String, Set<String>>();
            for (SecurityRole sr : this.roles) {
                for (IndexPattern ip : sr.getIpatterns()) {
                    Set<String> maskedFields = ip.getMaskedFields();
                    if (maskedFields.isEmpty()) continue;
                    String indexPattern = ip.getUnresolvedIndexPattern(user);
                    Set concreteIndices = ip.getResolvedIndexPattern(user, resolver, cs);
                    Set currentMaskedFields = (Set)maskedFieldsMap.get(indexPattern);
                    if (currentMaskedFields != null) {
                        currentMaskedFields.addAll(maskedFields);
                    } else {
                        maskedFieldsMap.put(indexPattern, new HashSet<String>(maskedFields));
                    }
                    for (String concreteIndex : concreteIndices) {
                        currentMaskedFields = (Set)maskedFieldsMap.get(concreteIndex);
                        if (currentMaskedFields != null) {
                            currentMaskedFields.addAll(maskedFields);
                            continue;
                        }
                        maskedFieldsMap.put(concreteIndex, new HashSet<String>(maskedFields));
                    }
                }
            }
            return maskedFieldsMap;
        }

        @Override
        public Tuple<Map<String, Set<String>>, Map<String, Set<String>>> getDlsFls(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashMap<String, HashSet<String>> dlsQueries = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> flsFields = new HashMap<String, HashSet<String>>();
            for (SecurityRole sr : this.roles) {
                for (IndexPattern ip : sr.getIpatterns()) {
                    Set<String> fls = ip.getFls();
                    String dls = ip.getDlsQuery(user);
                    String indexPattern = ip.getUnresolvedIndexPattern(user);
                    Set concreteIndices = new HashSet();
                    if (dls != null && dls.length() > 0 || fls != null && fls.size() > 0) {
                        concreteIndices = ip.getResolvedIndexPattern(user, resolver, cs);
                    }
                    if (dls != null && dls.length() > 0) {
                        Set dlsQuery = (Set)dlsQueries.get(indexPattern);
                        if (dlsQuery != null) {
                            dlsQuery.add(dls);
                        } else {
                            dlsQueries.put(indexPattern, new HashSet<String>(Arrays.asList(dls)));
                        }
                        for (String concreteIndex : concreteIndices) {
                            dlsQuery = (Set)dlsQueries.get(concreteIndex);
                            if (dlsQuery != null) {
                                dlsQuery.add(dls);
                                continue;
                            }
                            dlsQueries.put(concreteIndex, new HashSet<String>(Arrays.asList(dls)));
                        }
                    }
                    if (fls == null || fls.size() <= 0) continue;
                    Set flsField = (Set)flsFields.get(indexPattern);
                    if (flsField != null) {
                        flsField.addAll(fls);
                    } else {
                        flsFields.put(indexPattern, new HashSet<String>(fls));
                    }
                    for (String concreteIndex : concreteIndices) {
                        flsField = (Set)flsFields.get(concreteIndex);
                        if (flsField != null) {
                            flsField.addAll(fls);
                            continue;
                        }
                        flsFields.put(concreteIndex, new HashSet<String>(fls));
                    }
                }
            }
            return new Tuple(dlsQueries, flsFields);
        }

        @Override
        public Set<String> getAllPermittedIndicesForKibana(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<String> retVal = new HashSet<String>();
            for (SecurityRole sr : this.roles) {
                retVal.addAll(sr.getAllResolvedPermittedIndices(IndexResolverReplacer.Resolved._LOCAL_ALL, user, actions, resolver, cs));
                retVal.addAll(resolved.getRemoteIndices());
            }
            return Collections.unmodifiableSet(retVal);
        }

        @Override
        public Set<String> reduce(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet retVal = new HashSet();
            for (SecurityRole sr : this.roles) {
                retVal.addAll(sr.getAllResolvedPermittedIndices(resolved, user, actions, resolver, cs));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reduced requested resolved indices {} to permitted indices {}.", (Object)resolved, (Object)((Object)retVal).toString());
            }
            return Collections.unmodifiableSet(retVal);
        }

        @Override
        public boolean get(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            for (SecurityRole sr : this.roles) {
                if (!ConfigModelV7.impliesTypePerm(sr.getIpatterns(), resolved, user, actions, resolver, cs)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean impliesClusterPermissionPermission(String action) {
            return this.roles.stream().filter((? super T r) -> ((SecurityRole)r).impliesClusterPermission(action)).count() > 0L;
        }

        @Override
        public boolean impliesTypePermGlobal(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet ipatterns = new HashSet();
            this.roles.stream().forEach(p -> ipatterns.addAll(p.getIpatterns()));
            return ConfigModelV7.impliesTypePerm(ipatterns, resolved, user, actions, resolver, cs);
        }
    }

    private static interface ActionGroupResolver {
        public Set<String> resolvedActions(List<String> var1);
    }
}

