/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.rest;

import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.DynamicConfigFactory;
import com.amazon.opendistroforelasticsearch.security.securityconf.RoleMappings;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class TenantInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/tenantinfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_opendistro/_security/tenantinfo"));
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final AdminDNs adminDns;
    private final ConfigurationRepository configurationRepository;

    public TenantInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool, ClusterService clusterService, AdminDNs adminDns, ConfigurationRepository configurationRepository) {
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
        this.clusterService = clusterService;
        this.adminDns = adminDns;
        this.configurationRepository = configurationRepository;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)TenantInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                    if (!TenantInfoAction.this.isAuthorized()) {
                        response = new BytesRestResponse(RestStatus.FORBIDDEN, "");
                    } else {
                        builder.startObject();
                        SortedMap lookup = TenantInfoAction.this.clusterService.state().metadata().getIndicesLookup();
                        for (String indexOrAlias : lookup.keySet()) {
                            String tenant = TenantInfoAction.this.tenantNameForIndex(indexOrAlias);
                            if (tenant == null) continue;
                            builder.field(indexOrAlias, tenant);
                        }
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.OK, builder);
                    }
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    private boolean isAuthorized() {
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        if (user == null) {
            return false;
        }
        if (user.getName().equals(this.evaluator.kibanaServerUsername()) || this.adminDns.isAdmin(user)) {
            return true;
        }
        SecurityDynamicConfiguration<?> rolesMappingConfiguration = this.load(CType.ROLESMAPPING, true);
        if (rolesMappingConfiguration != null) {
            String kibanaOpendistroRole = this.evaluator.kibanaOpendistroRole();
            if (Strings.isNullOrEmpty((String)kibanaOpendistroRole)) {
                return false;
            }
            RoleMappings roleMapping = rolesMappingConfiguration.getCEntries().getOrDefault(kibanaOpendistroRole, null);
            return roleMapping != null && roleMapping.getUsers().contains(user.getName());
        }
        return false;
    }

    private final SecurityDynamicConfiguration<?> load(CType config, boolean logComplianceEvent) {
        SecurityDynamicConfiguration<?> loaded = this.configurationRepository.getConfigurationsFromIndex(Collections.singleton(config), logComplianceEvent).get((Object)config).deepClone();
        return DynamicConfigFactory.addStatics(loaded);
    }

    private String tenantNameForIndex(String index) {
        String[] indexParts;
        if (index == null || (indexParts = index.split("_")).length != 3) {
            return null;
        }
        if (!indexParts[0].equals(this.evaluator.kibanaIndex())) {
            return null;
        }
        try {
            int expectedHash = Integer.parseInt(indexParts[1]);
            String sanitizedName = indexParts[2];
            for (String tenant : this.evaluator.getAllConfiguredTenantNames()) {
                if (tenant.hashCode() != expectedHash || !sanitizedName.equals(tenant.toLowerCase().replaceAll("[^a-z0-9]+", ""))) continue;
                return tenant;
            }
            return "__private__";
        }
        catch (NumberFormatException e) {
            this.log.warn("Index " + index + " looks like a Security tenant index but we cannot parse the hashcode so we ignore it.");
            return null;
        }
    }

    public String getName() {
        return "Tenant Info Action";
    }

    static /* synthetic */ Logger access$400(TenantInfoAction x0) {
        return x0.log;
    }
}

