/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.rest;

import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.support.Base64Helper;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class OpenDistroSecurityInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/authinfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_opendistro/_security/authinfo"));
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;

    public OpenDistroSecurityInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool) {
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    boolean verbose = request.paramAsBoolean("verbose", false);
                    X509Certificate[] certs = (X509Certificate[])OpenDistroSecurityInfoAction.this.threadContext.getTransient("_opendistro_security_ssl_peer_certificates");
                    User user = (User)OpenDistroSecurityInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                    TransportAddress remoteAddress = (TransportAddress)OpenDistroSecurityInfoAction.this.threadContext.getTransient("_opendistro_security_remote_address");
                    Set<String> securityRoles = OpenDistroSecurityInfoAction.this.evaluator.mapRoles(user, remoteAddress);
                    builder.startObject();
                    builder.field("user", user == null ? null : user.toString());
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("user_requested_tenant", user == null ? null : user.getRequestedTenant());
                    builder.field("remote_address", (ToXContent)remoteAddress);
                    builder.field("backend_roles", user == null ? null : user.getRoles());
                    builder.field("custom_attribute_names", user == null ? null : user.getCustomAttributesMap().keySet());
                    builder.field("roles", securityRoles);
                    builder.field("tenants", OpenDistroSecurityInfoAction.this.evaluator.mapTenants(user, securityRoles));
                    builder.field("principal", (String)OpenDistroSecurityInfoAction.this.threadContext.getTransient("_opendistro_security_ssl_principal"));
                    builder.field("peer_certificates", certs != null && certs.length > 0 ? certs.length + "" : "0");
                    builder.field("sso_logout_url", (String)OpenDistroSecurityInfoAction.this.threadContext.getTransient("_opendistro_security_sso_logout_url"));
                    if (user != null && verbose) {
                        try {
                            builder.field("size_of_user", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject(user).length()));
                            builder.field("size_of_custom_attributes", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject((Serializable)((Object)user.getCustomAttributesMap())).getBytes(StandardCharsets.UTF_8).length));
                            builder.field("size_of_backendroles", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject((Serializable)((Object)user.getRoles())).getBytes(StandardCharsets.UTF_8).length));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Open Distro Security Info Action";
    }

    static /* synthetic */ Logger access$200(OpenDistroSecurityInfoAction x0) {
        return x0.log;
    }
}

