/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.rest;

import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class KibanaInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/kibanainfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_opendistro/_security/kibanainfo"));
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;

    public KibanaInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool) {
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)KibanaInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                    builder.startObject();
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("not_fail_on_forbidden_enabled", KibanaInfoAction.this.evaluator.notFailOnForbiddenEnabled());
                    builder.field("kibana_mt_enabled", KibanaInfoAction.this.evaluator.multitenancyEnabled());
                    builder.field("kibana_index", KibanaInfoAction.this.evaluator.kibanaIndex());
                    builder.field("kibana_server_user", KibanaInfoAction.this.evaluator.kibanaServerUsername());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Kibana Info Action";
    }

    static /* synthetic */ Logger access$200(KibanaInfoAction x0) {
        return x0.log;
    }
}

