/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.privileges;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.ClusterInfoHolder;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluatorResponse;
import com.amazon.opendistroforelasticsearch.security.support.SnapshotRestoreHelper;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public class SnapshotRestoreEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final boolean enableSnapshotRestorePrivilege;
    private final String opendistrosecurityIndex;
    private final AuditLog auditLog;
    private final boolean restoreSecurityIndexEnabled;

    public SnapshotRestoreEvaluator(Settings settings, AuditLog auditLog) {
        this.enableSnapshotRestorePrivilege = settings.getAsBoolean("opendistro_security.enable_snapshot_restore_privilege", Boolean.valueOf(true));
        this.restoreSecurityIndexEnabled = settings.getAsBoolean("opendistro_security.unsupported.restore.securityindex.enabled", Boolean.valueOf(false));
        this.opendistrosecurityIndex = settings.get("opendistro_security.config_index_name", ".opendistro_security");
        this.auditLog = auditLog;
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, ClusterInfoHolder clusterInfoHolder, PrivilegesEvaluatorResponse presponse) {
        if (!(request instanceof RestoreSnapshotRequest)) {
            return presponse;
        }
        if (!this.enableSnapshotRestorePrivilege) {
            this.log.warn(action + " is not allowed for a regular user");
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (this.restoreSecurityIndexEnabled) {
            presponse.allowed = true;
            return presponse;
        }
        if (clusterInfoHolder.isLocalNodeElectedMaster() == Boolean.FALSE) {
            presponse.allowed = true;
            return presponse.markComplete();
        }
        RestoreSnapshotRequest restoreRequest = (RestoreSnapshotRequest)request;
        if (restoreRequest.includeGlobalState()) {
            this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
            this.log.warn(action + " with 'include_global_state' enabled is not allowed");
            presponse.allowed = false;
            return presponse.markComplete();
        }
        List<String> rs = SnapshotRestoreHelper.resolveOriginalIndices(restoreRequest);
        if (rs != null && (rs.contains(this.opendistrosecurityIndex) || rs.contains("_all") || rs.contains("*"))) {
            this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
            this.log.warn(action + " for '{}' as source index is not allowed", (Object)this.opendistrosecurityIndex);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        return presponse;
    }
}

