/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.privileges;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;

public class PrivilegesEvaluatorResponse {
    boolean allowed = false;
    Set<String> missingPrivileges = new HashSet<String>();
    Map<String, Set<String>> allowedFlsFields;
    Map<String, Set<String>> maskedFields;
    Map<String, Set<String>> queries;
    PrivilegesEvaluatorResponseState state = PrivilegesEvaluatorResponseState.PENDING;
    CreateIndexRequest request;

    public boolean isAllowed() {
        return this.allowed;
    }

    public Set<String> getMissingPrivileges() {
        return new HashSet<String>(this.missingPrivileges);
    }

    public Map<String, Set<String>> getAllowedFlsFields() {
        return this.allowedFlsFields;
    }

    public Map<String, Set<String>> getMaskedFields() {
        return this.maskedFields;
    }

    public Map<String, Set<String>> getQueries() {
        return this.queries;
    }

    public CreateIndexRequest getRequest() {
        return this.request;
    }

    public PrivilegesEvaluatorResponse markComplete() {
        this.state = PrivilegesEvaluatorResponseState.COMPLETE;
        return this;
    }

    public PrivilegesEvaluatorResponse markPending() {
        this.state = PrivilegesEvaluatorResponseState.PENDING;
        return this;
    }

    public boolean isComplete() {
        return this.state == PrivilegesEvaluatorResponseState.COMPLETE;
    }

    public boolean isPending() {
        return this.state == PrivilegesEvaluatorResponseState.PENDING;
    }

    public String toString() {
        return "PrivEvalResponse [allowed=" + this.allowed + ", missingPrivileges=" + this.missingPrivileges + ", allowedFlsFields=" + this.allowedFlsFields + ", maskedFields=" + this.maskedFields + ", queries=" + this.queries + "]";
    }

    public static enum PrivilegesEvaluatorResponseState {
        PENDING,
        COMPLETE;

    }
}

