/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.privileges;

import com.amazon.opendistroforelasticsearch.security.OpenDistroSecurityPlugin;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.ClusterInfoHolder;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.privileges.DlsFlsEvaluator;
import com.amazon.opendistroforelasticsearch.security.privileges.OpenDistroProtectedIndexAccessEvaluator;
import com.amazon.opendistroforelasticsearch.security.privileges.OpenDistroSecurityIndexAccessEvaluator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluatorResponse;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesInterceptor;
import com.amazon.opendistroforelasticsearch.security.privileges.SnapshotRestoreEvaluator;
import com.amazon.opendistroforelasticsearch.security.privileges.TermsAggregationEvaluator;
import com.amazon.opendistroforelasticsearch.security.resolver.IndexResolverReplacer;
import com.amazon.opendistroforelasticsearch.security.securityconf.ConfigModel;
import com.amazon.opendistroforelasticsearch.security.securityconf.DynamicConfigModel;
import com.amazon.opendistroforelasticsearch.security.securityconf.SecurityRoles;
import com.amazon.opendistroforelasticsearch.security.support.ConfigConstants;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.greenrobot.eventbus.Subscribe;

public class PrivilegesEvaluator {
    private static final WildcardMatcher ACTION_MATCHER = WildcardMatcher.from("indices:data/read/*search*");
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private final AuditLog auditLog;
    private ThreadContext threadContext;
    private PrivilegesInterceptor privilegesInterceptor;
    private final boolean checkSnapshotRestoreWritePrivileges;
    private final ClusterInfoHolder clusterInfoHolder;
    private ConfigModel configModel;
    private final IndexResolverReplacer irr;
    private final SnapshotRestoreEvaluator snapshotRestoreEvaluator;
    private final OpenDistroSecurityIndexAccessEvaluator securityIndexAccessEvaluator;
    private final OpenDistroProtectedIndexAccessEvaluator protectedIndexAccessEvaluator;
    private final TermsAggregationEvaluator termsAggregationEvaluator;
    private final DlsFlsEvaluator dlsFlsEvaluator;
    private final boolean dlsFlsEnabled;
    private DynamicConfigModel dcm;

    public PrivilegesEvaluator(ClusterService clusterService, ThreadPool threadPool, ConfigurationRepository configurationRepository, IndexNameExpressionResolver resolver, AuditLog auditLog, Settings settings, PrivilegesInterceptor privilegesInterceptor, ClusterInfoHolder clusterInfoHolder, IndexResolverReplacer irr, boolean dlsFlsEnabled) {
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.privilegesInterceptor = privilegesInterceptor;
        this.checkSnapshotRestoreWritePrivileges = settings.getAsBoolean("opendistro_security.check_snapshot_restore_write_privileges", Boolean.valueOf(true));
        this.clusterInfoHolder = clusterInfoHolder;
        this.irr = irr;
        this.snapshotRestoreEvaluator = new SnapshotRestoreEvaluator(settings, auditLog);
        this.securityIndexAccessEvaluator = new OpenDistroSecurityIndexAccessEvaluator(settings, auditLog, irr);
        this.protectedIndexAccessEvaluator = new OpenDistroProtectedIndexAccessEvaluator(settings, auditLog);
        this.dlsFlsEvaluator = new DlsFlsEvaluator(settings, threadPool);
        this.termsAggregationEvaluator = new TermsAggregationEvaluator();
        this.dlsFlsEnabled = dlsFlsEnabled;
    }

    @Subscribe
    public void onConfigModelChanged(ConfigModel configModel) {
        this.configModel = configModel;
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.dcm = dcm;
    }

    private SecurityRoles getSecurityRoles(Set<String> roles) {
        return this.configModel.getSecurityRoles().filter(roles);
    }

    public boolean isInitialized() {
        return this.configModel != null && this.configModel.getSecurityRoles() != null && this.dcm != null;
    }

    private void setUserInfoInThreadContext(User user, Set<String> mappedRoles) {
        if (this.threadContext.getTransient("_opendistro_security_user_info") == null) {
            StringJoiner joiner = new StringJoiner("|");
            joiner.add(user.getName());
            joiner.add(String.join((CharSequence)",", user.getRoles()));
            joiner.add(String.join((CharSequence)",", (Iterable<? extends CharSequence>)Sets.union(user.getOpenDistroSecurityRoles(), mappedRoles)));
            String requestedTenant = user.getRequestedTenant();
            if (!Strings.isNullOrEmpty((String)requestedTenant)) {
                joiner.add(requestedTenant);
            }
            this.threadContext.putTransient("_opendistro_security_user_info", (Object)joiner.toString());
        }
    }

    public PrivilegesEvaluatorResponse evaluate(User user, String action0, ActionRequest request, Task task, Set<String> injectedRoles) {
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Open Distro Security is not initialized.", new Object[0]);
        }
        if (action0.startsWith("internal:indices/admin/upgrade")) {
            action0 = "indices:admin/upgrade";
        }
        if ("indices:admin/auto_create".equals(action0)) {
            action0 = "indices:admin/create";
        }
        if ("indices:admin/mapping/auto_put".equals(action0)) {
            action0 = "indices:admin/mapping/put";
        }
        TransportAddress caller = (TransportAddress)this.threadContext.getTransient("_opendistro_security_remote_address");
        Set<String> mappedRoles = injectedRoles == null ? this.mapRoles(user, caller) : injectedRoles;
        SecurityRoles securityRoles = this.getSecurityRoles(mappedRoles);
        this.setUserInfoInThreadContext(user, mappedRoles);
        PrivilegesEvaluatorResponse presponse = new PrivilegesEvaluatorResponse();
        if (this.log.isDebugEnabled()) {
            this.log.debug("### evaluate permissions for {} on {}", (Object)user, (Object)this.clusterService.localNode().getName());
            this.log.debug("action: " + action0 + " (" + request.getClass().getSimpleName() + ")");
            this.log.debug("mapped roles: {}", (Object)mappedRoles.toString());
        }
        if (request instanceof BulkRequest && Strings.isNullOrEmpty((String)user.getRequestedTenant())) {
            if (!securityRoles.impliesClusterPermissionPermission(action0)) {
                presponse.missingPrivileges.add(action0);
                presponse.allowed = false;
                this.log.info("No cluster-level perm match for {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)action0, securityRoles.getRoleNames(), presponse.missingPrivileges);
            } else {
                presponse.allowed = true;
            }
            return presponse;
        }
        IndexResolverReplacer.Resolved requestedResolved = this.irr.resolveRequest(request);
        if (this.log.isDebugEnabled()) {
            this.log.debug("requestedResolved : {}", (Object)requestedResolved);
        }
        if (this.dlsFlsEnabled && this.dlsFlsEvaluator.evaluate(request, this.clusterService, this.resolver, requestedResolved, user, securityRoles, presponse).isComplete()) {
            return presponse;
        }
        if (this.snapshotRestoreEvaluator.evaluate(request, task, action0, this.clusterInfoHolder, presponse).isComplete()) {
            return presponse;
        }
        if (this.securityIndexAccessEvaluator.evaluate(request, task, action0, requestedResolved, presponse).isComplete()) {
            return presponse;
        }
        if (this.protectedIndexAccessEvaluator.evaluate(request, task, action0, requestedResolved, presponse, securityRoles).isComplete()) {
            return presponse;
        }
        boolean dnfofEnabled = this.dcm.isDnfofEnabled();
        if (this.log.isTraceEnabled()) {
            this.log.trace("dnfof enabled? {}", (Object)dnfofEnabled);
        }
        if (PrivilegesEvaluator.isClusterPerm(action0)) {
            if (!securityRoles.impliesClusterPermissionPermission(action0)) {
                presponse.missingPrivileges.add(action0);
                presponse.allowed = false;
                this.log.info("No cluster-level perm match for {} {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)requestedResolved, (Object)action0, securityRoles.getRoleNames(), presponse.missingPrivileges);
                return presponse;
            }
            if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Normally allowed but we need to apply some extra checks for a restore request.");
                }
            } else {
                if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
                    PrivilegesInterceptor.ReplaceResult replaceResult = this.privilegesInterceptor.replaceKibanaIndex(request, action0, user, this.dcm, requestedResolved, this.mapTenants(user, mappedRoles));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Result from privileges interceptor for cluster perm: {}", (Object)replaceResult);
                    }
                    if (!replaceResult.continueEvaluation) {
                        if (replaceResult.accessDenied) {
                            this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                        } else {
                            presponse.allowed = true;
                            presponse.request = replaceResult.createIndexRequest;
                        }
                        return presponse;
                    }
                }
                if (dnfofEnabled && action0.startsWith("indices:data/read/") && !requestedResolved.getAllIndices().isEmpty()) {
                    if (requestedResolved.getAllIndices().isEmpty()) {
                        presponse.missingPrivileges.clear();
                        presponse.allowed = true;
                        return presponse;
                    }
                    Set<String> reduced = securityRoles.reduce(requestedResolved, user, new String[]{action0}, this.resolver, this.clusterService);
                    if (reduced.isEmpty()) {
                        presponse.allowed = false;
                        return presponse;
                    }
                    if (this.irr.replace((TransportRequest)request, true, reduced.toArray(new String[0]))) {
                        presponse.missingPrivileges.clear();
                        presponse.allowed = true;
                        return presponse;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Allowed because we have cluster permissions for " + action0);
                }
                presponse.allowed = true;
                return presponse;
            }
        }
        if (this.termsAggregationEvaluator.evaluate(requestedResolved, request, this.clusterService, user, securityRoles, this.resolver, presponse).isComplete()) {
            return presponse;
        }
        Set<String> allIndexPermsRequired = this.evaluateAdditionalIndexPermissions(request, action0);
        String[] allIndexPermsRequiredA = allIndexPermsRequired.toArray(new String[0]);
        if (this.log.isDebugEnabled()) {
            this.log.debug("requested {} from {}", allIndexPermsRequired, (Object)caller);
        }
        presponse.missingPrivileges.clear();
        presponse.missingPrivileges.addAll(allIndexPermsRequired);
        if (this.log.isDebugEnabled()) {
            this.log.debug("requested resolved indextypes: {}", (Object)requestedResolved);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sr: {}", securityRoles.getRoleNames());
        }
        if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
            PrivilegesInterceptor.ReplaceResult replaceResult = this.privilegesInterceptor.replaceKibanaIndex(request, action0, user, this.dcm, requestedResolved, this.mapTenants(user, mappedRoles));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Result from privileges interceptor: {}", (Object)replaceResult);
            }
            if (!replaceResult.continueEvaluation) {
                if (replaceResult.accessDenied) {
                    this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                } else {
                    presponse.allowed = true;
                    presponse.request = replaceResult.createIndexRequest;
                }
                return presponse;
            }
        }
        if (dnfofEnabled && (action0.startsWith("indices:data/read/") || action0.startsWith("indices:admin/mappings/fields/get") || action0.equals("indices:admin/shards/search_shards"))) {
            if (requestedResolved.getAllIndices().isEmpty()) {
                presponse.missingPrivileges.clear();
                presponse.allowed = true;
                return presponse;
            }
            Set<String> reduced = securityRoles.reduce(requestedResolved, user, allIndexPermsRequiredA, this.resolver, this.clusterService);
            if (reduced.isEmpty()) {
                if (this.dcm.isDnfofForEmptyResultsEnabled()) {
                    if (request instanceof SearchRequest) {
                        ((SearchRequest)request).indices(new String[0]);
                        ((SearchRequest)request).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
                        presponse.missingPrivileges.clear();
                        presponse.allowed = true;
                        return presponse;
                    }
                    if (request instanceof ClusterSearchShardsRequest) {
                        ((ClusterSearchShardsRequest)request).indices(new String[0]);
                        ((ClusterSearchShardsRequest)request).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
                        presponse.missingPrivileges.clear();
                        presponse.allowed = true;
                        return presponse;
                    }
                    if (request instanceof GetFieldMappingsRequest) {
                        ((GetFieldMappingsRequest)request).indices(new String[0]);
                        ((GetFieldMappingsRequest)request).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
                        presponse.missingPrivileges.clear();
                        presponse.allowed = true;
                        return presponse;
                    }
                }
                presponse.allowed = false;
                return presponse;
            }
            if (this.irr.replace((TransportRequest)request, true, reduced.toArray(new String[0]))) {
                presponse.missingPrivileges.clear();
                presponse.allowed = true;
                return presponse;
            }
        }
        boolean permGiven = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug("sr2: {}", securityRoles.getRoleNames());
        }
        if (!(permGiven = this.dcm.isMultiRolespanEnabled() ? securityRoles.impliesTypePermGlobal(requestedResolved, user, allIndexPermsRequiredA, this.resolver, this.clusterService) : securityRoles.get(requestedResolved, user, allIndexPermsRequiredA, this.resolver, this.clusterService))) {
            this.log.info("No {}-level perm match for {} {} [Action [{}]] [RolesChecked {}]", (Object)"index", (Object)user, (Object)requestedResolved, (Object)action0, securityRoles.getRoleNames());
            this.log.info("No permissions for {}", presponse.missingPrivileges);
        } else {
            if (this.checkFilteredAliases(requestedResolved.getAllIndices(), action0)) {
                presponse.allowed = false;
                return presponse;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Allowed because we have all indices permissions for " + action0);
            }
        }
        presponse.allowed = permGiven;
        return presponse;
    }

    public Set<String> mapRoles(User user, TransportAddress caller) {
        return this.configModel.mapSecurityRoles(user, caller);
    }

    public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
        return this.configModel.mapTenants(user, roles);
    }

    public Set<String> getAllConfiguredTenantNames() {
        return this.configModel.getAllConfiguredTenantNames();
    }

    public boolean multitenancyEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.dcm.isKibanaMultitenancyEnabled();
    }

    public boolean notFailOnForbiddenEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.dcm.isDnfofEnabled();
    }

    public String kibanaIndex() {
        return this.dcm.getKibanaIndexname();
    }

    public String kibanaServerUsername() {
        return this.dcm.getKibanaServerUsername();
    }

    public String kibanaOpendistroRole() {
        return this.dcm.getKibanaOpendistroRole();
    }

    private Set<String> evaluateAdditionalIndexPermissions(ActionRequest request, String originalAction) {
        CreateIndexRequest cir;
        BulkShardRequest bsr;
        HashSet<String> additionalPermissionsRequired = new HashSet<String>();
        if (!PrivilegesEvaluator.isClusterPerm(originalAction)) {
            additionalPermissionsRequired.add(originalAction);
        }
        if (request instanceof ClusterSearchShardsRequest) {
            additionalPermissionsRequired.add("indices:data/read/search");
        }
        if (request instanceof BulkShardRequest) {
            bsr = (BulkShardRequest)request;
            block9: for (BulkItemRequest bir : bsr.items()) {
                switch (bir.request().opType()) {
                    case CREATE: {
                        additionalPermissionsRequired.add("indices:data/write/index");
                        continue block9;
                    }
                    case INDEX: {
                        additionalPermissionsRequired.add("indices:data/write/index");
                        continue block9;
                    }
                    case DELETE: {
                        additionalPermissionsRequired.add("indices:data/write/delete");
                        continue block9;
                    }
                    case UPDATE: {
                        additionalPermissionsRequired.add("indices:data/write/update");
                    }
                }
            }
        }
        if (request instanceof IndicesAliasesRequest) {
            bsr = (IndicesAliasesRequest)request;
            for (IndicesAliasesRequest.AliasActions bir : bsr.getAliasActions()) {
                switch (bir.actionType()) {
                    case REMOVE_INDEX: {
                        additionalPermissionsRequired.add("indices:admin/delete");
                        break;
                    }
                }
            }
        }
        if (request instanceof CreateIndexRequest && (cir = (CreateIndexRequest)request).aliases() != null && !cir.aliases().isEmpty()) {
            additionalPermissionsRequired.add("indices:admin/aliases");
        }
        if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
            additionalPermissionsRequired.addAll(ConfigConstants.OPENDISTRO_SECURITY_SNAPSHOT_RESTORE_NEEDED_WRITE_PRIVILEGES);
        }
        if (additionalPermissionsRequired.size() > 1) {
            OpenDistroSecurityPlugin.traceAction("Additional permissions required: {}", additionalPermissionsRequired);
        }
        if (this.log.isDebugEnabled() && additionalPermissionsRequired.size() > 1) {
            this.log.debug("Additional permissions required: " + additionalPermissionsRequired);
        }
        return Collections.unmodifiableSet(additionalPermissionsRequired);
    }

    private static boolean isClusterPerm(String action0) {
        return action0.startsWith("cluster:") || action0.startsWith("indices:admin/template/") || action0.startsWith("indices:data/read/scroll") || action0.equals("indices:data/write/bulk") || action0.equals("indices:data/read/mget") || action0.equals("indices:data/read/msearch") || action0.equals("indices:data/read/mtv") || action0.equals("indices:data/write/reindex");
    }

    private boolean checkFilteredAliases(Set<String> requestedResolvedIndices, String action) {
        for (String requestAliasOrIndex : requestedResolvedIndices) {
            ArrayList<AliasMetadata> filteredAliases = new ArrayList<AliasMetadata>();
            IndexMetadata indexMetadata = (IndexMetadata)this.clusterService.state().metadata().getIndices().get((Object)requestAliasOrIndex);
            if (indexMetadata == null) {
                this.log.debug("{} does not exist in cluster metadata", (Object)requestAliasOrIndex);
                continue;
            }
            ImmutableOpenMap aliases = indexMetadata.getAliases();
            if (aliases != null && aliases.size() > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Aliases for {}: {}", (Object)requestAliasOrIndex, (Object)aliases);
                }
                Iterator it = aliases.keysIt();
                while (it.hasNext()) {
                    String alias = (String)it.next();
                    AliasMetadata aliasMetadata = (AliasMetadata)aliases.get((Object)alias);
                    if (aliasMetadata != null && aliasMetadata.filteringRequired()) {
                        filteredAliases.add(aliasMetadata);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug(alias + " is a filtered alias " + aliasMetadata.getFilter());
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug(alias + " is not an alias or does not have a filter");
                }
            }
            if (filteredAliases.size() <= 1 || !ACTION_MATCHER.test(action)) continue;
            String faMode = this.dcm.getFilteredAliasMode();
            if (faMode.equals("warn")) {
                this.log.warn("More than one ({}) filtered alias found for same index ({}). This is currently not recommended. Aliases: {}", (Object)filteredAliases.size(), (Object)requestAliasOrIndex, this.toString(filteredAliases));
                continue;
            }
            if (faMode.equals("disallow")) {
                this.log.error("More than one ({}) filtered alias found for same index ({}). This is currently not supported. Aliases: {}", (Object)filteredAliases.size(), (Object)requestAliasOrIndex, this.toString(filteredAliases));
                return true;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("More than one ({}) filtered alias found for same index ({}). Aliases: {}", (Object)filteredAliases.size(), (Object)requestAliasOrIndex, this.toString(filteredAliases));
        }
        return false;
    }

    private List<String> toString(List<AliasMetadata> aliases) {
        if (aliases == null || aliases.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(aliases.size());
        for (AliasMetadata amd : aliases) {
            if (amd == null) continue;
            ret.add(amd.alias());
        }
        return Collections.unmodifiableList(ret);
    }
}

