/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.privileges;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluatorResponse;
import com.amazon.opendistroforelasticsearch.security.resolver.IndexResolverReplacer;
import com.amazon.opendistroforelasticsearch.security.support.ConfigConstants;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public class OpenDistroSecurityIndexAccessEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final String opendistrosecurityIndex;
    private final AuditLog auditLog;
    private final WildcardMatcher securityDeniedActionMatcher;
    private final IndexResolverReplacer irr;
    private final boolean filterSecurityIndex;
    private final WildcardMatcher systemIndexMatcher;
    private final boolean systemIndexEnabled;

    public OpenDistroSecurityIndexAccessEvaluator(Settings settings, AuditLog auditLog, IndexResolverReplacer irr) {
        this.opendistrosecurityIndex = settings.get("opendistro_security.config_index_name", ".opendistro_security");
        this.auditLog = auditLog;
        this.irr = irr;
        this.filterSecurityIndex = settings.getAsBoolean("opendistro_security.filter_securityindex_from_all_requests", Boolean.valueOf(false));
        this.systemIndexMatcher = WildcardMatcher.from(settings.getAsList("opendistro_security.system_indices.indices", ConfigConstants.OPENDISTRO_SECURITY_SYSTEM_INDICES_DEFAULT));
        this.systemIndexEnabled = settings.getAsBoolean("opendistro_security.system_indices.enabled", ConfigConstants.OPENDISTRO_SECURITY_SYSTEM_INDICES_ENABLED_DEFAULT);
        boolean restoreSecurityIndexEnabled = settings.getAsBoolean("opendistro_security.unsupported.restore.securityindex.enabled", Boolean.valueOf(false));
        ArrayList<String> securityIndexDeniedActionPatternsList = new ArrayList<String>();
        securityIndexDeniedActionPatternsList.add("indices:data/write*");
        securityIndexDeniedActionPatternsList.add("indices:admin/delete*");
        securityIndexDeniedActionPatternsList.add("indices:admin/mapping/delete*");
        securityIndexDeniedActionPatternsList.add("indices:admin/mapping/put*");
        securityIndexDeniedActionPatternsList.add("indices:admin/freeze*");
        securityIndexDeniedActionPatternsList.add("indices:admin/settings/update*");
        securityIndexDeniedActionPatternsList.add("indices:admin/aliases");
        ArrayList<String> securityIndexDeniedActionPatternsListNoSnapshot = new ArrayList<String>();
        securityIndexDeniedActionPatternsListNoSnapshot.addAll(securityIndexDeniedActionPatternsList);
        securityIndexDeniedActionPatternsListNoSnapshot.add("indices:admin/close*");
        securityIndexDeniedActionPatternsListNoSnapshot.add("cluster:admin/snapshot/restore*");
        this.securityDeniedActionMatcher = WildcardMatcher.from(restoreSecurityIndexEnabled ? securityIndexDeniedActionPatternsList : securityIndexDeniedActionPatternsListNoSnapshot);
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, IndexResolverReplacer.Resolved requestedResolved, PrivilegesEvaluatorResponse presponse) {
        if ((requestedResolved.getAllIndices().contains(this.opendistrosecurityIndex) || this.matchAnySystemIndices(requestedResolved)) && this.securityDeniedActionMatcher.test(action)) {
            if (this.filterSecurityIndex) {
                HashSet<String> allWithoutSecurity = new HashSet<String>(requestedResolved.getAllIndices());
                allWithoutSecurity.remove(this.opendistrosecurityIndex);
                if (allWithoutSecurity.isEmpty()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Filtered '{}' but resulting list is empty", (Object)this.opendistrosecurityIndex);
                    }
                    presponse.allowed = false;
                    return presponse.markComplete();
                }
                this.irr.replace((TransportRequest)request, false, allWithoutSecurity.toArray(new String[0]));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Filtered '{}', resulting list is {}", (Object)this.opendistrosecurityIndex, allWithoutSecurity);
                }
                return presponse;
            }
            this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
            this.log.warn(action + " for '{}' index is not allowed for a regular user", (Object)this.opendistrosecurityIndex);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (requestedResolved.isLocalAll() && this.securityDeniedActionMatcher.test(action)) {
            if (this.filterSecurityIndex) {
                this.irr.replace((TransportRequest)request, false, "*", "-" + this.opendistrosecurityIndex);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Filtered '{}'from {}, resulting list with *,-{} is {}", (Object)this.opendistrosecurityIndex, (Object)requestedResolved, (Object)this.opendistrosecurityIndex, (Object)this.irr.resolveRequest(request));
                }
                return presponse;
            }
            this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
            this.log.warn(action + " for '_all' indices is not allowed for a regular user");
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (requestedResolved.getAllIndices().contains(this.opendistrosecurityIndex) || requestedResolved.isLocalAll() || this.matchAnySystemIndices(requestedResolved)) {
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).requestCache(Boolean.FALSE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable search request cache for this request");
                }
            }
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable realtime for this request");
                }
            }
        }
        return presponse;
    }

    private boolean matchAnySystemIndices(IndexResolverReplacer.Resolved requestedResolved) {
        return this.systemIndexEnabled && this.systemIndexMatcher.matchAny(requestedResolved.getAllIndices());
    }
}

