/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.privileges;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluatorResponse;
import com.amazon.opendistroforelasticsearch.security.resolver.IndexResolverReplacer;
import com.amazon.opendistroforelasticsearch.security.securityconf.SecurityRoles;
import com.amazon.opendistroforelasticsearch.security.support.ConfigConstants;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public class OpenDistroProtectedIndexAccessEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final AuditLog auditLog;
    private final WildcardMatcher indexMatcher;
    private final WildcardMatcher allowedRolesMatcher;
    private final Boolean protectedIndexEnabled;
    private final WildcardMatcher deniedActionMatcher;

    public OpenDistroProtectedIndexAccessEvaluator(Settings settings, AuditLog auditLog) {
        this.indexMatcher = WildcardMatcher.from(settings.getAsList("opendistro_security.protected_indices.indices", ConfigConstants.OPENDISTRO_SECURITY_PROTECTED_INDICES_DEFAULT));
        this.allowedRolesMatcher = WildcardMatcher.from(settings.getAsList("opendistro_security.protected_indices.roles", ConfigConstants.OPENDISTRO_SECURITY_PROTECTED_INDICES_ROLES_DEFAULT));
        this.protectedIndexEnabled = settings.getAsBoolean("opendistro_security.protected_indices.enabled", ConfigConstants.OPENDISTRO_SECURITY_PROTECTED_INDICES_ENABLED_DEFAULT);
        this.auditLog = auditLog;
        ArrayList<String> indexDeniedActionPatterns = new ArrayList<String>();
        indexDeniedActionPatterns.add("indices:data/write*");
        indexDeniedActionPatterns.add("indices:admin/delete*");
        indexDeniedActionPatterns.add("indices:admin/mapping/delete*");
        indexDeniedActionPatterns.add("indices:admin/mapping/put*");
        indexDeniedActionPatterns.add("indices:admin/freeze*");
        indexDeniedActionPatterns.add("indices:admin/settings/update*");
        indexDeniedActionPatterns.add("indices:admin/aliases");
        indexDeniedActionPatterns.add("indices:admin/close*");
        indexDeniedActionPatterns.add("cluster:admin/snapshot/restore*");
        this.deniedActionMatcher = WildcardMatcher.from(indexDeniedActionPatterns);
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, IndexResolverReplacer.Resolved requestedResolved, PrivilegesEvaluatorResponse presponse, SecurityRoles securityRoles) {
        if (!this.protectedIndexEnabled.booleanValue()) {
            return presponse;
        }
        if (this.indexMatcher.matchAny(requestedResolved.getAllIndices()) && this.deniedActionMatcher.test(action) && !this.allowedRolesMatcher.matchAny(securityRoles.getRoleNames())) {
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
            this.log.warn(action + " for '{}' index/indices is not allowed for a regular user", (Object)this.indexMatcher);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (requestedResolved.isLocalAll() && this.deniedActionMatcher.test(action) && !this.allowedRolesMatcher.matchAny(securityRoles.getRoleNames())) {
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
            this.log.warn(action + " for '_all' indices is not allowed for a regular user");
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if ((this.indexMatcher.matchAny(requestedResolved.getAllIndices()) || requestedResolved.isLocalAll()) && !this.allowedRolesMatcher.matchAny(securityRoles.getRoleNames())) {
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).requestCache(Boolean.FALSE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable search request cache for this request");
                }
            }
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable realtime for this request");
                }
            }
        }
        return presponse;
    }
}

