/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.privileges;

import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluatorResponse;
import com.amazon.opendistroforelasticsearch.security.resolver.IndexResolverReplacer;
import com.amazon.opendistroforelasticsearch.security.securityconf.SecurityRoles;
import com.amazon.opendistroforelasticsearch.security.support.Base64Helper;
import com.amazon.opendistroforelasticsearch.security.support.HeaderHelper;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public class DlsFlsEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ThreadPool threadPool;

    public DlsFlsEvaluator(Settings settings, ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, ClusterService clusterService, IndexNameExpressionResolver resolver, IndexResolverReplacer.Resolved requestedResolved, User user, SecurityRoles securityRoles, PrivilegesEvaluatorResponse presponse) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        Map<String, Set<String>> maskedFieldsMap = securityRoles.getMaskedFields(user, resolver, clusterService);
        if (maskedFieldsMap != null && !maskedFieldsMap.isEmpty()) {
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(threadContext)) {
                threadContext.addResponseHeader("_opendistro_security_masked_fields", Base64Helper.serializeObject((Serializable)((Object)maskedFieldsMap)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("added response header for masked fields info: {}", maskedFieldsMap);
                }
            } else if (threadContext.getHeader("_opendistro_security_masked_fields") != null) {
                if (!maskedFieldsMap.equals(Base64Helper.deserializeObject(threadContext.getHeader("_opendistro_security_masked_fields")))) {
                    throw new ElasticsearchSecurityException("_opendistro_security_masked_fields does not match  ", new Object[0]);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("_opendistro_security_masked_fields already set");
                }
            } else {
                threadContext.putHeader("_opendistro_security_masked_fields", Base64Helper.serializeObject((Serializable)((Object)maskedFieldsMap)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("attach masked fields info: {}", maskedFieldsMap);
                }
            }
            presponse.maskedFields = (Map)maskedFieldsMap.entrySet().stream().filter(requestedResolved.getAllIndices().isEmpty() ? entry -> true : entry -> WildcardMatcher.from((String)entry.getKey()).matchAny(requestedResolved.getAllIndices())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        Tuple<Map<String, Set<String>>, Map<String, Set<String>>> dlsFls = securityRoles.getDlsFls(user, resolver, clusterService);
        Map dlsQueries = (Map)dlsFls.v1();
        Map flsFields = (Map)dlsFls.v2();
        if (!dlsQueries.isEmpty()) {
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(threadContext)) {
                threadContext.addResponseHeader("_opendistro_security_dls_query", Base64Helper.serializeObject((Serializable)((Object)dlsQueries)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("added response header for DLS info: {}", (Object)dlsQueries);
                }
            } else if (threadContext.getHeader("_opendistro_security_dls_query") != null) {
                if (!dlsQueries.equals(Base64Helper.deserializeObject(threadContext.getHeader("_opendistro_security_dls_query")))) {
                    throw new ElasticsearchSecurityException("_opendistro_security_dls_query does not match (SG 900D)", new Object[0]);
                }
            } else {
                threadContext.putHeader("_opendistro_security_dls_query", Base64Helper.serializeObject((Serializable)((Object)dlsQueries)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("attach DLS info: {}", (Object)dlsQueries);
                }
            }
            presponse.queries = (Map)dlsQueries.entrySet().stream().filter(requestedResolved.getAllIndices().isEmpty() ? entry -> true : entry -> WildcardMatcher.from((String)entry.getKey()).matchAny(requestedResolved.getAllIndices())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (!flsFields.isEmpty()) {
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(threadContext)) {
                threadContext.addResponseHeader("_opendistro_security_fls_fields", Base64Helper.serializeObject((Serializable)((Object)flsFields)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("added response header for FLS info: {}", (Object)flsFields);
                }
            } else if (threadContext.getHeader("_opendistro_security_fls_fields") != null) {
                if (!flsFields.equals(Base64Helper.deserializeObject(threadContext.getHeader("_opendistro_security_fls_fields")))) {
                    throw new ElasticsearchSecurityException("_opendistro_security_fls_fields does not match  ", new Object[0]);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("_opendistro_security_fls_fields already set");
                }
            } else {
                threadContext.putHeader("_opendistro_security_fls_fields", Base64Helper.serializeObject((Serializable)((Object)flsFields)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("attach FLS info: {}", (Object)flsFields);
                }
            }
            presponse.allowedFlsFields = (Map)flsFields.entrySet().stream().filter(requestedResolved.getAllIndices().isEmpty() ? entry -> true : entry -> WildcardMatcher.from((String)entry.getKey()).matchAny(requestedResolved.getAllIndices())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return presponse;
    }
}

