/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.httpclient;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;

public class HttpClient
implements Closeable {
    private final KeyStore trustStore;
    private final Logger log = LogManager.getLogger(this.getClass());
    private RestHighLevelClient rclient;
    private String basicCredentials;
    private KeyStore keystore;
    private String keystoreAlias;
    private char[] keyPassword;
    private boolean verifyHostnames;
    private boolean ssl;
    private String[] supportedProtocols;
    private String[] supportedCipherSuites;

    public static HttpClientBuilder builder(String ... servers) {
        return new HttpClientBuilder(servers);
    }

    private HttpClient(KeyStore trustStore, String basicCredentials, KeyStore keystore, char[] keyPassword, String keystoreAlias, boolean verifyHostnames, boolean ssl, String[] supportedProtocols, String[] supportedCipherSuites, String ... servers) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        this.trustStore = trustStore;
        this.basicCredentials = basicCredentials;
        this.keystore = keystore;
        this.keyPassword = keyPassword;
        this.verifyHostnames = verifyHostnames;
        this.ssl = ssl;
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
        this.keystoreAlias = keystoreAlias;
        HttpHost[] hosts = Arrays.stream(servers).map(s -> s.split(":")).map(s -> new HttpHost(s[0], Integer.parseInt(s[1]), ssl ? "https" : "http")).collect(Collectors.toList()).toArray(new HttpHost[0]);
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        builder.setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
            }
        });
        builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                try {
                    return HttpClient.this.asyncClientBuilder(httpClientBuilder);
                }
                catch (Exception e) {
                    HttpClient.this.log.error("Unable to build http client", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
        this.rclient = new RestHighLevelClient(builder);
    }

    public boolean index(String content, String index, String type, boolean refresh) {
        try {
            IndexRequest ir = type == null ? new IndexRequest(index) : new IndexRequest(index, type);
            IndexResponse response = this.rclient.index(((IndexRequest)ir.setRefreshPolicy(refresh ? WriteRequest.RefreshPolicy.IMMEDIATE : WriteRequest.RefreshPolicy.NONE)).source(content, XContentType.JSON), RequestOptions.DEFAULT);
            return response.getShardInfo().getSuccessful() > 0 && response.getShardInfo().getFailed() == 0;
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    private final HttpAsyncClientBuilder asyncClientBuilder(HttpAsyncClientBuilder httpClientBuilder) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        if (this.ssl) {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Configure HTTP client with SSL");
            }
            if (this.trustStore != null) {
                sslContextBuilder.loadTrustMaterial(this.trustStore, null);
            }
            if (this.keystore != null) {
                sslContextBuilder.loadKeyMaterial(this.keystore, this.keyPassword, new PrivateKeyStrategy(){

                    public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
                        if (aliases == null || aliases.isEmpty()) {
                            return HttpClient.this.keystoreAlias;
                        }
                        if (HttpClient.this.keystoreAlias == null || HttpClient.this.keystoreAlias.isEmpty()) {
                            return aliases.keySet().iterator().next();
                        }
                        return HttpClient.this.keystoreAlias;
                    }
                });
            }
            NoopHostnameVerifier hnv = this.verifyHostnames ? new DefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
            SSLContext sslContext = sslContextBuilder.build();
            httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslContext, this.supportedProtocols, this.supportedCipherSuites, (HostnameVerifier)hnv));
        }
        if (this.basicCredentials != null) {
            httpClientBuilder.setDefaultHeaders((Collection)Lists.newArrayList((Object[])new BasicHeader[]{new BasicHeader("Authorization", "Basic " + this.basicCredentials)}));
        }
        int timeout = 5;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        httpClientBuilder.setDefaultRequestConfig(config);
        return httpClientBuilder;
    }

    @Override
    public void close() throws IOException {
        if (this.rclient != null) {
            this.rclient.close();
        }
    }

    public static class HttpClientBuilder {
        private KeyStore trustStore;
        private String basicCredentials;
        private KeyStore keystore;
        private String keystoreAlias;
        private char[] keyPassword;
        private boolean verifyHostnames;
        private String[] supportedProtocols = null;
        private String[] supportedCipherSuites = null;
        private final String[] servers;
        private boolean ssl;

        private HttpClientBuilder(String ... servers) {
            this.servers = Objects.requireNonNull(servers);
            if (this.servers.length == 0) {
                throw new IllegalArgumentException();
            }
        }

        public HttpClientBuilder enableSsl(KeyStore trustStore, boolean verifyHostnames) {
            this.ssl = true;
            this.trustStore = Objects.requireNonNull(trustStore);
            this.verifyHostnames = verifyHostnames;
            return this;
        }

        public HttpClientBuilder setBasicCredentials(String username, String password) {
            this.basicCredentials = HttpClientBuilder.encodeBasicHeader(Objects.requireNonNull(username), Objects.requireNonNull(password));
            return this;
        }

        public HttpClientBuilder setPkiCredentials(KeyStore keystore, char[] keyPassword, String keystoreAlias) {
            this.keystore = Objects.requireNonNull(keystore);
            this.keyPassword = keyPassword;
            this.keystoreAlias = keystoreAlias;
            return this;
        }

        public HttpClientBuilder setSupportedProtocols(String[] protocols) {
            this.supportedProtocols = protocols;
            return this;
        }

        public HttpClientBuilder setSupportedCipherSuites(String[] cipherSuites) {
            this.supportedCipherSuites = cipherSuites;
            return this;
        }

        public HttpClient build() throws Exception {
            return new HttpClient(this.trustStore, this.basicCredentials, this.keystore, this.keyPassword, this.keystoreAlias, this.verifyHostnames, this.ssl, this.supportedProtocols, this.supportedCipherSuites, this.servers);
        }

        private static String encodeBasicHeader(String username, String password) {
            return Base64.getEncoder().encodeToString((username + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8));
        }
    }
}

