/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.filter;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auth.BackendRegistry;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.CompatConfig;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.WhitelistingSettings;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.amazon.opendistroforelasticsearch.security.ssl.util.ExceptionUtils;
import com.amazon.opendistroforelasticsearch.security.ssl.util.SSLRequestHelper;
import com.amazon.opendistroforelasticsearch.security.support.HTTPHelper;
import com.amazon.opendistroforelasticsearch.security.user.User;
import java.nio.file.Path;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.greenrobot.eventbus.Subscribe;

public class OpenDistroSecurityRestFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final BackendRegistry registry;
    private final AuditLog auditLog;
    private final org.elasticsearch.common.util.concurrent.ThreadContext threadContext;
    private final PrincipalExtractor principalExtractor;
    private final Settings settings;
    private final Path configPath;
    private final CompatConfig compatConfig;
    private WhitelistingSettings whitelistingSettings;

    public OpenDistroSecurityRestFilter(BackendRegistry registry, AuditLog auditLog, ThreadPool threadPool, PrincipalExtractor principalExtractor, Settings settings, Path configPath, CompatConfig compatConfig) {
        this.registry = registry;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.principalExtractor = principalExtractor;
        this.settings = settings;
        this.configPath = configPath;
        this.compatConfig = compatConfig;
        this.whitelistingSettings = new WhitelistingSettings();
    }

    public RestHandler wrap(final RestHandler original, final AdminDNs adminDNs) {
        return new RestHandler(){

            public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
                User user;
                ThreadContext.clearAll();
                if (!OpenDistroSecurityRestFilter.this.checkAndAuthenticateRequest(request, channel, client) && (OpenDistroSecurityRestFilter.this.userIsSuperAdmin(user = (User)OpenDistroSecurityRestFilter.this.threadContext.getTransient("_opendistro_security_user"), adminDNs) || OpenDistroSecurityRestFilter.this.whitelistingSettings.checkRequestIsAllowed(request, channel, client))) {
                    original.handleRequest(request, channel, client);
                }
            }
        };
    }

    private boolean userIsSuperAdmin(User user, AdminDNs adminDNs) {
        return user != null && adminDNs.isAdmin(user);
    }

    private boolean checkAndAuthenticateRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        this.threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.REST.toString());
        if (HTTPHelper.containsBadHeader(request)) {
            ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
            this.log.error((Object)exception);
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
            return true;
        }
        if (SSLRequestHelper.containsBadHeader(this.threadContext, "_opendistro_security_")) {
            ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
            this.log.error((Object)exception);
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
            return true;
        }
        try {
            SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(this.settings, this.configPath, request, this.principalExtractor);
            if (sslInfo != null) {
                if (sslInfo.getPrincipal() != null) {
                    this.threadContext.putTransient("_opendistro_security_ssl_principal", (Object)sslInfo.getPrincipal());
                }
                if (sslInfo.getX509Certs() != null) {
                    this.threadContext.putTransient("_opendistro_security_ssl_peer_certificates", (Object)sslInfo.getX509Certs());
                }
                this.threadContext.putTransient("_opendistro_security_ssl_protocol", (Object)sslInfo.getProtocol());
                this.threadContext.putTransient("_opendistro_security_ssl_cipher", (Object)sslInfo.getCipher());
            }
        }
        catch (SSLPeerUnverifiedException e) {
            this.log.error("No ssl info", (Throwable)e);
            this.auditLog.logSSLException(request, e);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)e));
            return true;
        }
        if (!this.compatConfig.restAuthEnabled()) {
            return false;
        }
        if (request.method() != RestRequest.Method.OPTIONS && !"/_opendistro/_security/health".equals(request.path())) {
            if (!this.registry.authenticate(request, channel, this.threadContext)) {
                ThreadContext.remove((String)"user");
                return true;
            }
            ThreadContext.put((String)"user", (String)((User)this.threadContext.getTransient("_opendistro_security_user")).getName());
        }
        return false;
    }

    @Subscribe
    public void onWhitelistingSettingChanged(WhitelistingSettings whitelistingSettings) {
        this.whitelistingSettings = whitelistingSettings;
    }
}

