/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.filter;

import com.amazon.opendistroforelasticsearch.security.OpenDistroSecurityPlugin;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auth.BackendRegistry;
import com.amazon.opendistroforelasticsearch.security.auth.RolesInjector;
import com.amazon.opendistroforelasticsearch.security.compliance.ComplianceConfig;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.CompatConfig;
import com.amazon.opendistroforelasticsearch.security.configuration.DlsFlsRequestValve;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluatorResponse;
import com.amazon.opendistroforelasticsearch.security.resolver.IndexResolverReplacer;
import com.amazon.opendistroforelasticsearch.security.support.Base64Helper;
import com.amazon.opendistroforelasticsearch.security.support.HeaderHelper;
import com.amazon.opendistroforelasticsearch.security.support.SourceFieldsContext;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class OpenDistroSecurityFilter
implements ActionFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final PrivilegesEvaluator evalp;
    private final AdminDNs adminDns;
    private DlsFlsRequestValve dlsFlsValve;
    private final AuditLog auditLog;
    private final org.elasticsearch.common.util.concurrent.ThreadContext threadContext;
    private final ClusterService cs;
    private final CompatConfig compatConfig;
    private final IndexResolverReplacer indexResolverReplacer;
    private final WildcardMatcher immutableIndicesMatcher;
    private final RolesInjector rolesInjector;
    private final Client client;
    private final BackendRegistry backendRegistry;

    public OpenDistroSecurityFilter(Client client, Settings settings, PrivilegesEvaluator evalp, AdminDNs adminDns, DlsFlsRequestValve dlsFlsValve, AuditLog auditLog, ThreadPool threadPool, ClusterService cs, CompatConfig compatConfig, IndexResolverReplacer indexResolverReplacer, BackendRegistry backendRegistry) {
        this.client = client;
        this.evalp = evalp;
        this.adminDns = adminDns;
        this.dlsFlsValve = dlsFlsValve;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.cs = cs;
        this.compatConfig = compatConfig;
        this.indexResolverReplacer = indexResolverReplacer;
        this.immutableIndicesMatcher = WildcardMatcher.from(settings.getAsList("opendistro_security.compliance.immutable_indices", Collections.emptyList()));
        this.rolesInjector = new RolesInjector();
        this.backendRegistry = backendRegistry;
        this.log.info("{} indices are made immutable.", (Object)this.immutableIndicesMatcher);
    }

    @VisibleForTesting
    WildcardMatcher getImmutableIndicesMatcher() {
        return this.immutableIndicesMatcher;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
            ThreadContext.clearAll();
            this.apply0(task, action, request, listener, chain);
        }
    }

    private static Set<String> alias2Name(Set<Alias> aliases) {
        return (Set)aliases.stream().map(a -> a.name()).collect(ImmutableSet.toImmutableSet());
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void apply0(final Task task, final String action, final Request request, final ActionListener<Response> listener, final ActionFilterChain<Request, Response> chain) {
        try {
            boolean internalRequest;
            ComplianceConfig complianceConfig;
            if (this.threadContext.getTransient("_opendistro_security_origin") == null) {
                this.threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.LOCAL.toString());
            }
            if ((complianceConfig = this.auditLog.getComplianceConfig()) != null && complianceConfig.isEnabled()) {
                this.attachSourceFieldContext(request);
            }
            Set<String> injectedRoles = this.rolesInjector.injectUserAndRoles(this.threadContext);
            boolean enforcePrivilegesEvaluation = false;
            User user = (User)this.threadContext.getTransient("_opendistro_security_user");
            if (user == null && (user = this.backendRegistry.authenticate((TransportRequest)request, null, task, action)) != null) {
                this.threadContext.putTransient("_opendistro_security_user", (Object)user);
                enforcePrivilegesEvaluation = true;
            }
            boolean userIsAdmin = OpenDistroSecurityFilter.isUserAdmin(user, this.adminDns);
            boolean interClusterRequest = HeaderHelper.isInterClusterRequest(this.threadContext);
            boolean trustedClusterRequest = HeaderHelper.isTrustedClusterRequest(this.threadContext);
            boolean confRequest = "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_opendistro_security_conf_request"));
            boolean passThroughRequest = action.startsWith("indices:admin/seq_no") || action.equals("cluster:admin/opendistro_security/whoami");
            boolean bl = internalRequest = (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext)) && action.startsWith("internal:") && !action.startsWith("internal:transport/proxy");
            if (user != null) {
                ThreadContext.put((String)"user", (String)user.getName());
            }
            if (OpenDistroSecurityPlugin.isActionTraceEnabled()) {
                String count = "";
                if (request instanceof BulkRequest) {
                    count = "" + ((BulkRequest)request).requests().size();
                }
                if (request instanceof MultiGetRequest) {
                    count = "" + ((MultiGetRequest)request).getItems().size();
                }
                if (request instanceof MultiSearchRequest) {
                    count = "" + ((MultiSearchRequest)request).requests().size();
                }
                OpenDistroSecurityPlugin.traceAction("Node " + this.cs.localNode().getName() + " -> " + action + " (" + count + "): userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + this.threadContext.getTransient("_opendistro_security_origin") + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + request.remoteAddress());
                this.threadContext.putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " FILTER -> Node " + this.cs.localNode().getName() + " -> " + action + " userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + this.threadContext.getTransient("_opendistro_security_origin") + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + request.remoteAddress() + " " + this.threadContext.getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_opendistro_security_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
            }
            if (userIsAdmin || confRequest || internalRequest || passThroughRequest) {
                if (userIsAdmin && !confRequest && !internalRequest && !passThroughRequest) {
                    this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                    this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            if (this.immutableIndicesMatcher != WildcardMatcher.NONE) {
                boolean isImmutable = false;
                if (request instanceof BulkShardRequest) {
                    BulkItemRequest bsr;
                    BulkItemRequest[] bulkItemRequestArray = ((BulkShardRequest)request).items();
                    int n = bulkItemRequestArray.length;
                    for (int i = 0; i < n && !(isImmutable = this.checkImmutableIndices((bsr = bulkItemRequestArray[i]).request(), listener)); ++i) {
                    }
                } else {
                    isImmutable = this.checkImmutableIndices(request, listener);
                }
                if (isImmutable) {
                    return;
                }
            }
            if (AuditLog.Origin.LOCAL.toString().equals(this.threadContext.getTransient("_opendistro_security_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext)) && injectedRoles == null && !enforcePrivilegesEvaluation) {
                chain.proceed(task, action, request, listener);
                return;
            }
            if (user == null) {
                if (action.startsWith("cluster:monitor/state")) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                if ((interClusterRequest || trustedClusterRequest || request.remoteAddress() == null) && !this.compatConfig.transportInterClusterAuthEnabled()) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                this.log.error("No user found for " + action + " from " + request.remoteAddress() + " " + this.threadContext.getTransient("_opendistro_security_origin") + " via " + this.threadContext.getTransient("_opendistro_security_channel_type") + " " + this.threadContext.getHeaders());
                listener.onFailure((Exception)new ElasticsearchSecurityException("No user found for " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                return;
            }
            PrivilegesEvaluator eval = this.evalp;
            if (!eval.isInitialized()) {
                this.log.error("Open Distro Security not initialized for {}", (Object)action);
                listener.onFailure((Exception)new ElasticsearchSecurityException("Open Distro Security not initialized for " + action, RestStatus.SERVICE_UNAVAILABLE, new Object[0]));
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Evaluate permissions for user: {}", (Object)user.getName());
            }
            PrivilegesEvaluatorResponse pres = eval.evaluate(user, action, request, task, injectedRoles);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)pres);
            }
            if (pres.isAllowed()) {
                this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                if (!this.dlsFlsValve.invoke(request, listener, pres.getAllowedFlsFields(), pres.getMaskedFields(), pres.getQueries())) {
                    return;
                }
                final CreateIndexRequest createIndexRequest = pres.getRequest();
                if (createIndexRequest == null) {
                    chain.proceed(task, action, request, listener);
                } else {
                    this.client.admin().indices().create(createIndexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse createIndexResponse) {
                            if (createIndexResponse.isAcknowledged()) {
                                OpenDistroSecurityFilter.this.log.debug("Request to create index {} with aliases {} acknowledged, proceeding with {}", (Object)createIndexRequest.index(), (Object)OpenDistroSecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName());
                                chain.proceed(task, action, request, listener);
                            } else {
                                ElasticsearchException e = new ElasticsearchException("Request to create index {} with aliases {} was not acknowledged, failing {}", new Object[]{createIndexRequest.index(), OpenDistroSecurityFilter.alias2Name(createIndexRequest.aliases()), request.getClass().getSimpleName()});
                                OpenDistroSecurityFilter.this.log.error(e.getMessage());
                                listener.onFailure((Exception)e);
                            }
                        }

                        public void onFailure(Exception e) {
                            if (e instanceof ResourceAlreadyExistsException) {
                                OpenDistroSecurityFilter.this.log.debug("Request to create index {} with aliases {} failed as resource already exist, proceeding with {}", (Object)createIndexRequest.index(), (Object)OpenDistroSecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName(), (Object)e);
                                chain.proceed(task, action, request, listener);
                            } else {
                                OpenDistroSecurityFilter.this.log.error("Request to create index {} with aliases {} failed, failing {}", (Object)createIndexRequest.index(), (Object)OpenDistroSecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName(), (Object)e);
                                listener.onFailure(e);
                            }
                        }
                    });
                }
                return;
            }
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
            String err = injectedRoles == null ? String.format("no permissions for %s and %s", pres.getMissingPrivileges(), user) : String.format("no permissions for %s and associated roles %s", pres.getMissingPrivileges(), injectedRoles);
            this.log.debug(err);
            listener.onFailure((Exception)new ElasticsearchSecurityException(err, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        catch (ElasticsearchException e) {
            if (task != null) {
                this.log.debug("Failed to apply filter. Task id: {} ({}). Action: {}", (Object)task.getId(), (Object)task.getDescription(), (Object)action, (Object)e);
            } else {
                this.log.debug("Failed to apply filter. Action: {}", (Object)action, (Object)e);
            }
            listener.onFailure((Exception)((Object)e));
        }
        catch (Throwable e) {
            this.log.error("Unexpected exception " + e, e);
            listener.onFailure((Exception)new ElasticsearchSecurityException("Unexpected exception " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            return;
        }
    }

    private static boolean isUserAdmin(User user, AdminDNs adminDns) {
        return user != null && adminDns.isAdmin(user);
    }

    private void attachSourceFieldContext(ActionRequest request) {
        if (request instanceof SearchRequest && SourceFieldsContext.isNeeded((SearchRequest)request)) {
            if (this.threadContext.getHeader("_opendistro_security_source_field_context") == null) {
                String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((SearchRequest)request));
                this.threadContext.putHeader("_opendistro_security_source_field_context", serializedSourceFieldContext);
            }
        } else if (request instanceof GetRequest && SourceFieldsContext.isNeeded((GetRequest)request) && this.threadContext.getHeader("_opendistro_security_source_field_context") == null) {
            String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((GetRequest)request));
            this.threadContext.putHeader("_opendistro_security_source_field_context", serializedSourceFieldContext);
        }
    }

    private boolean checkImmutableIndices(Object request, ActionListener listener) {
        boolean isModifyIndexRequest;
        boolean bl = isModifyIndexRequest = request instanceof DeleteRequest || request instanceof UpdateRequest || request instanceof UpdateByQueryRequest || request instanceof DeleteByQueryRequest || request instanceof DeleteIndexRequest || request instanceof RestoreSnapshotRequest || request instanceof CloseIndexRequest || request instanceof IndicesAliasesRequest;
        if (isModifyIndexRequest && this.isRequestIndexImmutable(request)) {
            listener.onFailure((Exception)new ElasticsearchSecurityException("Index is immutable", RestStatus.FORBIDDEN, new Object[0]));
            return true;
        }
        if (request instanceof IndexRequest && this.isRequestIndexImmutable(request)) {
            ((IndexRequest)request).opType(DocWriteRequest.OpType.CREATE);
        }
        return false;
    }

    private boolean isRequestIndexImmutable(Object request) {
        IndexResolverReplacer.Resolved resolved = this.indexResolverReplacer.resolveRequest(request);
        Set<String> allIndices = resolved.getAllIndices();
        return this.immutableIndicesMatcher.matchAny(allIndices);
    }
}

