/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.validation;

import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.ssl.util.Utils;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;

public class CredentialsValidator
extends AbstractConfigurationValidator {
    public CredentialsValidator(RestRequest request, BytesReference ref, Settings esSettings, Object ... param) {
        super(request, ref, esSettings, param);
        this.payloadMandatory = true;
        this.allowedKeys.put("hash", AbstractConfigurationValidator.DataType.STRING);
        this.allowedKeys.put("password", AbstractConfigurationValidator.DataType.STRING);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        String regex = this.esSettings.get("opendistro_security.restapi.password_validation_regex", null);
        if ((this.request.method() == RestRequest.Method.PUT || this.request.method() == RestRequest.Method.PATCH) && this.content != null && this.content.length() > 1) {
            try {
                Map contentAsMap = (Map)XContentHelper.convertToMap((BytesReference)this.content, (boolean)false, (XContentType)XContentType.JSON).v2();
                String password = (String)contentAsMap.get("password");
                if (password != null) {
                    if (password.isEmpty()) {
                        this.errorType = AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
                        return false;
                    }
                    if (!Strings.isNullOrEmpty((String)regex)) {
                        if (!Pattern.compile("^" + regex + "$").matcher(password).matches()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Regex does not match password");
                            }
                            this.errorType = AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
                            return false;
                        }
                        String username = Utils.coalesce(this.request.param("name"), this.hasParams() ? (String)this.param[0] : null);
                        if (username == null || username.isEmpty()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Unable to validate username because no user is given");
                            }
                            return false;
                        }
                        if (username.toLowerCase().equals(password.toLowerCase())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Username must not match password");
                            }
                            this.errorType = AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
                            return false;
                        }
                    }
                }
            }
            catch (NotXContentException e) {
                this.log.error("Invalid xContent: " + (Object)((Object)e), (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

