/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.support;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class Utils {
    private static final ObjectMapper internalMapper = new ObjectMapper();

    public static Map<String, Object> convertJsonToxToStructuredMap(ToXContent jsonContent) {
        Map map = null;
        try {
            BytesReference bytes = XContentHelper.toXContent((ToXContent)jsonContent, (XContentType)XContentType.JSON, (boolean)false);
            map = (Map)XContentHelper.convertToMap((BytesReference)bytes, (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic((Exception)e1);
        }
        return map;
    }

    public static Map<String, Object> convertJsonToxToStructuredMap(String jsonContent) {
        Map map;
        block8: {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonContent);
            try {
                map = parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e1) {
                    throw ExceptionsHelper.convertToElastic((Exception)e1);
                }
            }
            parser.close();
        }
        return map;
    }

    public static BytesReference convertStructuredMapToBytes(Map<String, Object> structuredMap) {
        try {
            return BytesReference.bytes((XContentBuilder)JsonXContent.contentBuilder().map(structuredMap));
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static String convertStructuredMapToJson(Map<String, Object> structuredMap) {
        try {
            return XContentHelper.convertToJson((BytesReference)Utils.convertStructuredMapToBytes(structuredMap), (boolean)false, (XContentType)XContentType.JSON);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static JsonNode convertJsonToJackson(BytesReference jsonContent) {
        try {
            return DefaultObjectMapper.readTree(jsonContent.utf8ToString());
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic((Exception)e1);
        }
    }

    public static JsonNode convertJsonToJackson(ToXContent jsonContent, boolean omitDefaults) {
        try {
            HashMap<String, String> pm = new HashMap<String, String>(1);
            pm.put("omit_defaults", String.valueOf(omitDefaults));
            ToXContent.MapParams params = new ToXContent.MapParams(pm);
            BytesReference bytes = XContentHelper.toXContent((ToXContent)jsonContent, (XContentType)XContentType.JSON, (ToXContent.Params)params, (boolean)false);
            return DefaultObjectMapper.readTree(bytes.utf8ToString());
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic((Exception)e1);
        }
    }

    public static <T> T serializeToXContentToPojo(ToXContent jsonContent, Class<T> clazz) {
        try {
            if (jsonContent instanceof BytesReference) {
                return Utils.serializeToXContentToPojo(((BytesReference)jsonContent).utf8ToString(), clazz);
            }
            BytesReference bytes = XContentHelper.toXContent((ToXContent)jsonContent, (XContentType)XContentType.JSON, (boolean)false);
            return DefaultObjectMapper.readValue(bytes.utf8ToString(), clazz);
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic((Exception)e1);
        }
    }

    public static <T> T serializeToXContentToPojo(String jsonContent, Class<T> clazz) {
        try {
            return DefaultObjectMapper.readValue(jsonContent, clazz);
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic((Exception)e1);
        }
    }

    public static byte[] jsonMapToByteArray(final Map<String, Object> jsonAsMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return internalMapper.writeValueAsBytes((Object)jsonAsMap);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof JsonProcessingException) {
                throw (JsonProcessingException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static Map<String, Object> byteArrayToMutableJsonMap(final byte[] jsonBytes) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, Object>>(){

                @Override
                public Map<String, Object> run() throws Exception {
                    return (Map)internalMapper.readValue(jsonBytes, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static String hash(char[] clearTextPassword) {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        String hash = OpenBSDBCrypt.generate((char[])Objects.requireNonNull(clearTextPassword), (byte[])salt, (int)12);
        Arrays.fill(salt, (byte)0);
        Arrays.fill(clearTextPassword, '\u0000');
        return hash;
    }

    public static Set<String> generateFieldResourcePaths(Set<String> fields, String prefix) {
        return (Set)fields.stream().map(field -> prefix + field).collect(ImmutableSet.toImmutableSet());
    }
}

