/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.AbstractApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.Endpoint;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.PatchableResourceApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.WhitelistValidator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class WhitelistApiAction
extends PatchableResourceApiAction {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/whitelist"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_security/api/whitelist"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_opendistro/_security/api/whitelist"));
    private static final String name = "config";

    @Inject
    public WhitelistApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        if (!this.isSuperAdmin()) {
            this.forbidden(channel, "API allowed only for super admin.");
            return;
        }
        super.handleApiRequest(channel, request, client);
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        SecurityDynamicConfiguration<?> configuration = this.load(this.getConfigName(), true);
        this.filter(configuration);
        this.successResponse(channel, configuration);
    }

    @Override
    protected void handleDelete(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.DELETE);
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        SecurityDynamicConfiguration<?> existingConfiguration = this.load(this.getConfigName(), false);
        if (existingConfiguration.getSeqNo() < 0L) {
            this.forbidden(channel, "Security index need to be updated to support '" + this.getConfigName().toLCString() + "'. Use OpenDistroSecurityAdmin to populate.");
            return;
        }
        final boolean existed = existingConfiguration.exists(name);
        existingConfiguration.putCObject(name, DefaultObjectMapper.readTree(content, existingConfiguration.getImplementingClass()));
        this.saveAnUpdateConfigs(client, request, this.getConfigName(), existingConfiguration, new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (existed) {
                    WhitelistApiAction.this.successResponse(channel, "'config' updated.");
                } else {
                    WhitelistApiAction.this.createdResponse(channel, "'config' created.");
                }
            }
        });
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.WHITELIST;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new WhitelistValidator(request, ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return name;
    }

    @Override
    protected CType getConfigName() {
        return CType.WHITELIST;
    }
}

