/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.AbstractApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.Endpoint;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.PatchableResourceApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.RolesMappingValidator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class RolesMappingApiAction
extends PatchableResourceApiAction {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/rolesmapping/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_opendistro/_security/api/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_security/api/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_opendistro/_security/api/rolesmapping/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_opendistro/_security/api/rolesmapping/{name}"));

    @Inject
    public RolesMappingApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        final String name = request.param("name");
        if (name == null || name.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        SecurityDynamicConfiguration<?> rolesMappingConfiguration = this.load(this.getConfigName(), false);
        final boolean rolesMappingExists = rolesMappingConfiguration.exists(name);
        if (!this.isValidRolesMapping(channel, name)) {
            return;
        }
        rolesMappingConfiguration.putCObject(name, DefaultObjectMapper.readTree(content, rolesMappingConfiguration.getImplementingClass()));
        this.saveAnUpdateConfigs(client, request, this.getConfigName(), rolesMappingConfiguration, new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (rolesMappingExists) {
                    RolesMappingApiAction.this.successResponse(channel, "'" + name + "' updated.");
                } else {
                    RolesMappingApiAction.this.createdResponse(channel, "'" + name + "' created.");
                }
            }
        });
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.ROLESMAPPING;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new RolesMappingValidator(request, this.isSuperAdmin(), ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return "rolesmapping";
    }

    @Override
    protected CType getConfigName() {
        return CType.ROLESMAPPING;
    }
}

