/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.Endpoint;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.RestApiPrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class PermissionsInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/permissionsinfo"));
    private final RestApiPrivilegesEvaluator restApiPrivilegesEvaluator;
    private final ThreadPool threadPool;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final ConfigurationRepository configurationRepository;

    protected PermissionsInfoAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository configurationRepository, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator privilegesEvaluator, ThreadPool threadPool, AuditLog auditLog) {
        this.threadPool = threadPool;
        this.privilegesEvaluator = privilegesEvaluator;
        this.restApiPrivilegesEvaluator = new RestApiPrivilegesEvaluator(settings, adminDNs, privilegesEvaluator, principalExtractor, configPath, threadPool);
        this.configurationRepository = configurationRepository;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        switch (request.method()) {
            case GET: {
                return this.handleGet(request, client);
            }
        }
        throw new IllegalArgumentException(request.method() + " not supported");
    }

    private BaseRestHandler.RestChannelConsumer handleGet(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)PermissionsInfoAction.this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
                    TransportAddress remoteAddress = (TransportAddress)PermissionsInfoAction.this.threadPool.getThreadContext().getTransient("_opendistro_security_remote_address");
                    Set<String> userRoles = PermissionsInfoAction.this.privilegesEvaluator.mapRoles(user, remoteAddress);
                    Boolean hasApiAccess = PermissionsInfoAction.this.restApiPrivilegesEvaluator.currentUserHasRestApiAccess(userRoles);
                    Map<Endpoint, List<RestRequest.Method>> disabledEndpoints = PermissionsInfoAction.this.restApiPrivilegesEvaluator.getDisabledEndpointsForCurrentUser(user.getName(), userRoles);
                    if (!PermissionsInfoAction.this.configurationRepository.isAuditHotReloadingEnabled()) {
                        disabledEndpoints.put(Endpoint.AUDIT, (List<RestRequest.Method>)ImmutableList.copyOf((Object[])RestRequest.Method.values()));
                    }
                    builder.startObject();
                    builder.field("user", user == null ? null : user.toString());
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("has_api_access", hasApiAccess);
                    builder.startObject("disabled_endpoints");
                    for (Map.Entry<Endpoint, List<RestRequest.Method>> entry : disabledEndpoints.entrySet()) {
                        builder.field(entry.getKey().name(), (Iterable)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }
}

