/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.AbstractApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.support.Utils;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.JsonPatch;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class PatchableResourceApiAction
extends AbstractApiAction {
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    public PatchableResourceApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    private void handlePatch(RestChannel channel, RestRequest request, Client client) throws IOException {
        JsonNode jsonPatch;
        if (request.getXContentType() != XContentType.JSON) {
            this.badRequestResponse(channel, "PATCH accepts only application/json");
            return;
        }
        String name = request.param("name");
        SecurityDynamicConfiguration<?> existingConfiguration = this.load(this.getConfigName(), false);
        if (existingConfiguration.getSeqNo() < 0L) {
            this.forbidden(channel, "Config '" + this.getConfigName().toLCString() + "' isn't configured. Use OpenDistroSecurityAdmin to populate.");
            return;
        }
        try {
            jsonPatch = DefaultObjectMapper.readTree(request.content().utf8ToString());
        }
        catch (IOException e) {
            this.log.debug("Error while parsing JSON patch", (Throwable)e);
            this.badRequestResponse(channel, "Error in JSON patch: " + e.getMessage());
            return;
        }
        JsonNode existingAsJsonNode = Utils.convertJsonToJackson(existingConfiguration, true);
        if (!(existingAsJsonNode instanceof ObjectNode)) {
            this.internalErrorResponse(channel, "Config " + (Object)((Object)this.getConfigName()) + " is malformed");
            return;
        }
        ObjectNode existingAsObjectNode = (ObjectNode)existingAsJsonNode;
        if (Strings.isNullOrEmpty((String)name)) {
            this.handleBulkPatch(channel, request, client, existingConfiguration, existingAsObjectNode, jsonPatch);
        } else {
            this.handleSinglePatch(channel, request, client, name, existingConfiguration, existingAsObjectNode, jsonPatch);
        }
    }

    private void handleSinglePatch(final RestChannel channel, RestRequest request, Client client, final String name, SecurityDynamicConfiguration<?> existingConfiguration, ObjectNode existingAsObjectNode, JsonNode jsonPatch) throws IOException {
        JsonNode patchedResourceAsJsonNode;
        if (!this.isWriteable(channel, existingConfiguration, name)) {
            return;
        }
        if (!existingConfiguration.exists(name)) {
            this.notFound(channel, this.getResourceName() + " " + name + " not found.");
            return;
        }
        JsonNode existingResourceAsJsonNode = existingAsObjectNode.get(name);
        try {
            patchedResourceAsJsonNode = this.applyPatch(jsonPatch, existingResourceAsJsonNode);
        }
        catch (JsonPatchApplicationException e) {
            this.log.debug("Error while applying JSON patch", (Throwable)e);
            this.badRequestResponse(channel, e.getMessage());
            return;
        }
        AbstractConfigurationValidator originalValidator = this.postProcessApplyPatchResult(channel, request, existingResourceAsJsonNode, patchedResourceAsJsonNode, name);
        if (originalValidator != null && !originalValidator.validate()) {
            request.params().clear();
            this.badRequestResponse(channel, originalValidator);
            return;
        }
        if (this.isReadonlyFieldUpdated(existingResourceAsJsonNode, patchedResourceAsJsonNode)) {
            request.params().clear();
            this.conflict(channel, "Attempted to update read-only property.");
            return;
        }
        AbstractConfigurationValidator validator = this.getValidator(request, patchedResourceAsJsonNode);
        if (!validator.validate()) {
            request.params().clear();
            this.badRequestResponse(channel, validator);
            return;
        }
        JsonNode updatedAsJsonNode = existingAsObjectNode.deepCopy().set(name, patchedResourceAsJsonNode);
        SecurityDynamicConfiguration mdc = SecurityDynamicConfiguration.fromNode(updatedAsJsonNode, existingConfiguration.getCType(), existingConfiguration.getVersion(), existingConfiguration.getSeqNo(), existingConfiguration.getPrimaryTerm());
        this.saveAnUpdateConfigs(client, request, this.getConfigName(), mdc, new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                PatchableResourceApiAction.this.successResponse(channel, "'" + name + "' updated.");
            }
        });
    }

    private void handleBulkPatch(final RestChannel channel, RestRequest request, Client client, SecurityDynamicConfiguration<?> existingConfiguration, ObjectNode existingAsObjectNode, JsonNode jsonPatch) throws IOException {
        JsonNode patchedResource;
        JsonNode oldResource;
        JsonNode patchedAsJsonNode;
        try {
            patchedAsJsonNode = this.applyPatch(jsonPatch, (JsonNode)existingAsObjectNode);
        }
        catch (JsonPatchApplicationException e) {
            this.log.debug("Error while applying JSON patch", (Throwable)e);
            this.badRequestResponse(channel, e.getMessage());
            return;
        }
        for (String resourceName : existingConfiguration.getCEntries().keySet()) {
            oldResource = existingAsObjectNode.get(resourceName);
            patchedResource = patchedAsJsonNode.get(resourceName);
            if (oldResource == null || oldResource.equals((Object)patchedResource) || this.isWriteable(channel, existingConfiguration, resourceName)) continue;
            return;
        }
        Iterator fieldNamesIter = patchedAsJsonNode.fieldNames();
        while (fieldNamesIter.hasNext()) {
            AbstractConfigurationValidator validator;
            String resourceName;
            resourceName = (String)fieldNamesIter.next();
            oldResource = existingAsObjectNode.get(resourceName);
            AbstractConfigurationValidator originalValidator = this.postProcessApplyPatchResult(channel, request, oldResource, patchedResource = patchedAsJsonNode.get(resourceName), resourceName);
            if (originalValidator != null && !originalValidator.validate()) {
                request.params().clear();
                this.badRequestResponse(channel, originalValidator);
                return;
            }
            if (this.isReadonlyFieldUpdated(oldResource, patchedResource)) {
                request.params().clear();
                this.conflict(channel, "Attempted to update read-only property.");
                return;
            }
            if (oldResource != null && oldResource.equals((Object)patchedResource) || (validator = this.getValidator(request, patchedResource)).validate()) continue;
            request.params().clear();
            this.badRequestResponse(channel, validator);
            return;
        }
        SecurityDynamicConfiguration mdc = SecurityDynamicConfiguration.fromNode(patchedAsJsonNode, existingConfiguration.getCType(), existingConfiguration.getVersion(), existingConfiguration.getSeqNo(), existingConfiguration.getPrimaryTerm());
        this.saveAnUpdateConfigs(client, request, this.getConfigName(), mdc, new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                PatchableResourceApiAction.this.successResponse(channel, "Resource updated.");
            }
        });
    }

    private JsonNode applyPatch(JsonNode jsonPatch, JsonNode existingResourceAsJsonNode) {
        return JsonPatch.apply((JsonNode)jsonPatch, (JsonNode)existingResourceAsJsonNode);
    }

    protected AbstractConfigurationValidator postProcessApplyPatchResult(RestChannel channel, RestRequest request, JsonNode existingResourceAsJsonNode, JsonNode updatedResourceAsJsonNode, String resourceName) {
        return null;
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        if (request.method() == RestRequest.Method.PATCH) {
            this.handlePatch(channel, request, client);
        } else {
            super.handleApiRequest(channel, request, client);
        }
    }

    private AbstractConfigurationValidator getValidator(RestRequest request, JsonNode patchedResource) throws JsonProcessingException {
        BytesArray patchedResourceAsByteReference = new BytesArray(DefaultObjectMapper.objectMapper.writeValueAsString((Object)patchedResource).getBytes(StandardCharsets.UTF_8));
        return this.getValidator(request, (BytesReference)patchedResourceAsByteReference, new Object[0]);
    }
}

