/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.Endpoint;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.PatchableResourceApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.NodesDnValidator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.NodesDn;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class NodesDnApiAction
extends PatchableResourceApiAction {
    public static final String STATIC_ES_YML_NODES_DN = "STATIC_ES_YML_NODES_DN";
    private final List<String> staticNodesDnFromEsYml;
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/nodesdn/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_opendistro/_security/api/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_security/api/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_opendistro/_security/api/nodesdn/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_opendistro/_security/api/nodesdn/{name}"));

    @Inject
    public NodesDnApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
        this.staticNodesDnFromEsYml = settings.getAsList("opendistro_security.nodes_dn", Collections.emptyList());
    }

    public List<RestHandler.Route> routes() {
        if (this.settings.getAsBoolean("opendistro_security.nodes_dn_dynamic_config_enabled", Boolean.valueOf(false)).booleanValue()) {
            return routes;
        }
        return Collections.emptyList();
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        if (!this.isSuperAdmin()) {
            this.forbidden(channel, "API allowed only for admin.");
            return;
        }
        super.handleApiRequest(channel, request, client);
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("name");
        request.param("show_all");
    }

    @Override
    protected boolean isReadOnly(SecurityDynamicConfiguration<?> existingConfiguration, String name) {
        if (STATIC_ES_YML_NODES_DN.equals(name)) {
            return true;
        }
        return super.isReadOnly(existingConfiguration, name);
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        String resourcename = request.param("name");
        SecurityDynamicConfiguration<?> configuration = this.load(this.getConfigName(), true);
        this.filter(configuration);
        if (resourcename == null || resourcename.length() == 0) {
            Boolean showAll = request.paramAsBoolean("show_all", Boolean.FALSE);
            if (showAll.booleanValue()) {
                this.putStaticEntry(configuration);
            }
            this.successResponse(channel, configuration);
            return;
        }
        if (!configuration.exists(resourcename)) {
            this.notFound(channel, "Resource '" + resourcename + "' not found.");
            return;
        }
        configuration.removeOthers(resourcename);
        this.successResponse(channel, configuration);
    }

    private void putStaticEntry(SecurityDynamicConfiguration<?> configuration) {
        if (!NodesDn.class.equals(configuration.getImplementingClass())) {
            throw new RuntimeException("Unknown class type - " + configuration.getImplementingClass());
        }
        NodesDn nodesDn = new NodesDn();
        nodesDn.setNodesDn(this.staticNodesDnFromEsYml);
        configuration.putCEntry(STATIC_ES_YML_NODES_DN, nodesDn);
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.NODESDN;
    }

    @Override
    protected String getResourceName() {
        return "nodesdn";
    }

    @Override
    protected CType getConfigName() {
        return CType.NODESDN;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        return new NodesDnValidator(request, ref, this.settings, params);
    }
}

