/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auditlog.config.AuditConfig;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.AbstractApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.Endpoint;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.NoOpValidator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.Migration;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.NodesDn;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.WhitelistingSettings;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v6.ConfigV6;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v6.InternalUserV6;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v6.RoleMappingsV6;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v6.RoleV6;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.ActionGroupsV7;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.ConfigV7;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.InternalUserV7;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.RoleMappingsV7;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.RoleV7;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.v7.TenantV7;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class MigrateApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_opendistro/_security/api/migrate"));

    @Inject
    public MigrateApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.MIGRATE;
    }

    @Override
    protected void handlePost(final RestChannel channel, RestRequest request, final Client client, JsonNode content) throws IOException {
        Version oldestNodeVersion = this.cs.state().getNodes().getMinNodeVersion();
        if (oldestNodeVersion.before(Version.V_7_0_0)) {
            this.badRequestResponse(channel, "Can not migrate configuration because cluster is not fully migrated.");
            return;
        }
        SecurityDynamicConfiguration<ConfigV6> loadedConfig = this.load(CType.CONFIG, true);
        if (loadedConfig.getVersion() != 1) {
            this.badRequestResponse(channel, "Can not migrate configuration because it was already migrated.");
            return;
        }
        SecurityDynamicConfiguration<ConfigV6> configV6 = loadedConfig;
        SecurityDynamicConfiguration<?> actionGroupsV6 = this.load(CType.ACTIONGROUPS, true);
        SecurityDynamicConfiguration<InternalUserV6> internalUsersV6 = this.load(CType.INTERNALUSERS, true);
        SecurityDynamicConfiguration<RoleV6> rolesV6 = this.load(CType.ROLES, true);
        SecurityDynamicConfiguration<RoleMappingsV6> rolesmappingV6 = this.load(CType.ROLESMAPPING, true);
        SecurityDynamicConfiguration<NodesDn> nodesDnV6 = this.load(CType.NODESDN, true);
        SecurityDynamicConfiguration<WhitelistingSettings> whitelistingSettingV6 = this.load(CType.WHITELIST, true);
        SecurityDynamicConfiguration<AuditConfig> auditConfigV6 = this.load(CType.AUDIT, true);
        final ImmutableList.Builder builder = ImmutableList.builder();
        SecurityDynamicConfiguration<ActionGroupsV7> actionGroupsV7 = Migration.migrateActionGroups(actionGroupsV6);
        builder.add(actionGroupsV7);
        SecurityDynamicConfiguration<ConfigV7> configV7 = Migration.migrateConfig(configV6);
        builder.add(configV7);
        SecurityDynamicConfiguration<InternalUserV7> internalUsersV7 = Migration.migrateInternalUsers(internalUsersV6);
        builder.add(internalUsersV7);
        Tuple<SecurityDynamicConfiguration<RoleV7>, SecurityDynamicConfiguration<TenantV7>> rolesTenantsV7 = Migration.migrateRoles(rolesV6, rolesmappingV6);
        builder.add((Object)((SecurityDynamicConfiguration)rolesTenantsV7.v1()));
        builder.add((Object)((SecurityDynamicConfiguration)rolesTenantsV7.v2()));
        SecurityDynamicConfiguration<RoleMappingsV7> rolesmappingV7 = Migration.migrateRoleMappings(rolesmappingV6);
        builder.add(rolesmappingV7);
        SecurityDynamicConfiguration<NodesDn> nodesDnV7 = Migration.migrateNodesDn(nodesDnV6);
        builder.add(nodesDnV7);
        SecurityDynamicConfiguration<WhitelistingSettings> whitelistingSettingV7 = Migration.migrateWhitelistingSetting(whitelistingSettingV6);
        builder.add(whitelistingSettingV7);
        SecurityDynamicConfiguration<AuditConfig> auditConfigV7 = Migration.migrateAudit(auditConfigV6);
        builder.add(auditConfigV7);
        int replicas = this.cs.state().metadata().index(this.opendistroIndex).getNumberOfReplicas();
        String autoExpandReplicas = this.cs.state().metadata().index(this.opendistroIndex).getSettings().get("index.auto_expand_replicas");
        final Settings.Builder securityIndexSettings = Settings.builder();
        if (autoExpandReplicas == null) {
            securityIndexSettings.put("index.number_of_replicas", replicas);
        } else {
            securityIndexSettings.put("index.auto_expand_replicas", autoExpandReplicas);
        }
        securityIndexSettings.put("index.number_of_shards", 1);
        client.admin().indices().prepareDelete(new String[]{this.opendistroIndex}).execute((ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    MigrateApiAction.this.log.debug("opendistro_security index deleted successfully");
                    client.admin().indices().prepareCreate(MigrateApiAction.this.opendistroIndex).setSettings(securityIndexSettings).execute((ActionListener)new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse response) {
                            ImmutableList dynamicConfigurations = builder.build();
                            ImmutableList.Builder cTypes = ImmutableList.builderWithExpectedSize((int)dynamicConfigurations.size());
                            BulkRequestBuilder br = client.prepareBulk(MigrateApiAction.this.opendistroIndex, "_doc");
                            br.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            try {
                                for (SecurityDynamicConfiguration dynamicConfiguration : dynamicConfigurations) {
                                    String id = dynamicConfiguration.getCType().toLCString();
                                    BytesReference xContent = XContentHelper.toXContent((ToXContent)dynamicConfiguration, (XContentType)XContentType.JSON, (boolean)false);
                                    br.add(new IndexRequest().id(id).source(new Object[]{id, xContent}));
                                    cTypes.add((Object)id);
                                }
                            }
                            catch (IOException e1) {
                                MigrateApiAction.this.log.error("Unable to create bulk request " + e1, (Throwable)e1);
                                MigrateApiAction.this.internalErrorResponse(channel, "Unable to create bulk request.");
                                return;
                            }
                            br.execute(new AbstractApiAction.ConfigUpdatingActionListener<BulkResponse>((String[])cTypes.build().toArray((Object[])new String[0]), client, new ActionListener<BulkResponse>(){

                                public void onResponse(BulkResponse response) {
                                    if (response.hasFailures()) {
                                        MigrateApiAction.this.log.error("Unable to upload migrated configuration because of " + response.buildFailureMessage());
                                        MigrateApiAction.this.internalErrorResponse(channel, "Unable to upload migrated configuration (bulk index failed).");
                                    } else {
                                        MigrateApiAction.this.log.debug("Migration completed");
                                        MigrateApiAction.this.successResponse(channel, "Migration completed.");
                                    }
                                }

                                public void onFailure(Exception e) {
                                    MigrateApiAction.this.log.error("Unable to upload migrated configuration because of " + e, (Throwable)e);
                                    MigrateApiAction.this.internalErrorResponse(channel, "Unable to upload migrated configuration.");
                                }
                            }));
                        }

                        public void onFailure(Exception e) {
                            MigrateApiAction.this.log.error("Unable to create opendistro_security index because of " + e, (Throwable)e);
                            MigrateApiAction.this.internalErrorResponse(channel, "Unable to create opendistro_security index.");
                        }
                    });
                } else {
                    MigrateApiAction.this.log.error("Unable to create opendistro_security index.");
                }
            }

            public void onFailure(Exception e) {
                MigrateApiAction.this.log.error("Unable to delete opendistro_security index because of " + e, (Throwable)e);
                MigrateApiAction.this.internalErrorResponse(channel, "Unable to delete opendistro_security index.");
            }
        });
    }

    @Override
    protected void handleDelete(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.GET);
    }

    @Override
    protected void handlePut(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.PUT);
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new NoOpValidator(request, ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return null;
    }

    @Override
    protected CType getConfigName() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }
}

