/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.AbstractApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.Endpoint;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.PatchableResourceApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.support.Utils;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.InternalUsersValidator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.Hashed;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.amazon.opendistroforelasticsearch.security.support.SecurityJsonNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalUsersApiAction
extends PatchableResourceApiAction {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/user/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_opendistro/_security/api/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_security/api/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/internalusers/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_opendistro/_security/api/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_security/api/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_opendistro/_security/api/internalusers/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_opendistro/_security/api/internalusers/{name}"));

    @Inject
    public InternalUsersApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.INTERNALUSERS;
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        final String username = request.param("name");
        if (username == null || username.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        SecurityDynamicConfiguration<?> internalUsersConfiguration = this.load(this.getConfigName(), false);
        if (!this.isWriteable(channel, internalUsersConfiguration, username)) {
            return;
        }
        ObjectNode contentAsNode = (ObjectNode)content;
        SecurityJsonNode securityJsonNode = new SecurityJsonNode((JsonNode)contentAsNode);
        List<String> opendistroSecurityRoles = securityJsonNode.get("opendistro_security_roles").asList();
        if (opendistroSecurityRoles != null) {
            for (String role : opendistroSecurityRoles) {
                if (this.isValidRolesMapping(channel, role)) continue;
                return;
            }
        }
        String plainTextPassword = securityJsonNode.get("password").asString();
        String origHash = securityJsonNode.get("hash").asString();
        if (plainTextPassword != null && plainTextPassword.length() > 0) {
            contentAsNode.remove("password");
            contentAsNode.put("hash", Utils.hash(plainTextPassword.toCharArray()));
        } else if (origHash != null && origHash.length() > 0) {
            contentAsNode.remove("password");
        } else if (plainTextPassword != null && plainTextPassword.isEmpty() && origHash == null) {
            contentAsNode.remove("password");
        }
        final boolean userExisted = internalUsersConfiguration.exists(username);
        if (!userExisted && securityJsonNode.get("hash").asString() == null) {
            this.badRequestResponse(channel, "Please specify either 'hash' or 'password' when creating a new internal user.");
            return;
        }
        if (userExisted && securityJsonNode.get("hash").asString() == null) {
            String hash = ((Hashed)internalUsersConfiguration.getCEntry(username)).getHash();
            if (hash == null || hash.length() == 0) {
                this.internalErrorResponse(channel, "Existing user " + username + " has no password, and no new password or hash was specified.");
                return;
            }
            contentAsNode.put("hash", hash);
        }
        internalUsersConfiguration.remove(username);
        internalUsersConfiguration.putCObject(username, DefaultObjectMapper.readTree((JsonNode)contentAsNode, internalUsersConfiguration.getImplementingClass()));
        this.saveAnUpdateConfigs(client, request, CType.INTERNALUSERS, internalUsersConfiguration, new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (userExisted) {
                    InternalUsersApiAction.this.successResponse(channel, "'" + username + "' updated.");
                } else {
                    InternalUsersApiAction.this.createdResponse(channel, "'" + username + "' created.");
                }
            }
        });
    }

    @Override
    protected void filter(SecurityDynamicConfiguration<?> builder) {
        super.filter(builder);
        builder.clearHashes();
    }

    @Override
    protected AbstractConfigurationValidator postProcessApplyPatchResult(RestChannel channel, RestRequest request, JsonNode existingResourceAsJsonNode, JsonNode updatedResourceAsJsonNode, String resourceName) {
        AbstractConfigurationValidator retVal = null;
        JsonNode passwordNode = updatedResourceAsJsonNode.get("password");
        if (passwordNode != null) {
            String plainTextPassword = passwordNode.asText();
            try {
                XContentBuilder builder = channel.newBuilder();
                builder.startObject();
                builder.field("password", plainTextPassword);
                builder.endObject();
                retVal = this.getValidator(request, BytesReference.bytes((XContentBuilder)builder), resourceName);
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
            ((ObjectNode)updatedResourceAsJsonNode).remove("password");
            ((ObjectNode)updatedResourceAsJsonNode).set("hash", (JsonNode)new TextNode(Utils.hash(plainTextPassword.toCharArray())));
            return retVal;
        }
        return null;
    }

    @Override
    protected String getResourceName() {
        return "user";
    }

    @Override
    protected CType getConfigName() {
        return CType.INTERNALUSERS;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        return new InternalUsersValidator(request, this.isSuperAdmin(), ref, this.settings, params);
    }
}

