/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auditlog.config.AuditConfig;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.configuration.StaticResourceException;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.Endpoint;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.PatchableResourceApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.support.Utils;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AuditValidator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class AuditApiAction
extends PatchableResourceApiAction {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/audit/"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_security/api/audit/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_opendistro/_security/api/audit/"));
    private static final String RESOURCE_NAME = "config";
    @VisibleForTesting
    public static final String READONLY_FIELD = "_readonly";
    @VisibleForTesting
    public static final String STATIC_RESOURCE = "/static_config/static_audit.yml";
    private final List<String> readonlyFields;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final ThreadContext threadContext;

    public AuditApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator privilegesEvaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, privilegesEvaluator, threadPool, auditLog);
        this.privilegesEvaluator = privilegesEvaluator;
        this.threadContext = threadPool.getThreadContext();
        try {
            this.readonlyFields = (List)((Map)DefaultObjectMapper.YAML_MAPPER.readValue(((Object)((Object)this)).getClass().getResourceAsStream(STATIC_RESOURCE), (TypeReference)new TypeReference<Map<String, List<String>>>(){})).get(READONLY_FIELD);
            if (!AuditConfig.FIELD_PATHS.containsAll(this.readonlyFields)) {
                throw new StaticResourceException("Invalid read-only field paths provided in static resource file /static_config/static_audit.yml", new Object[0]);
            }
        }
        catch (IOException e) {
            throw new StaticResourceException("Unable to load audit static resource file", e, new Object[0]);
        }
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        if (!this.cl.isAuditHotReloadingEnabled()) {
            this.notImplemented(channel, request.method());
            return;
        }
        super.handleApiRequest(channel, request, client);
    }

    @Override
    protected void handlePut(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        if (!RESOURCE_NAME.equals(request.param("name"))) {
            this.badRequestResponse(channel, "name must be config");
            return;
        }
        super.handlePut(channel, request, client, content);
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) {
        SecurityDynamicConfiguration<?> configuration = this.load(this.getConfigName(), true);
        this.filter(configuration);
        String resourcename = this.getResourceName();
        if (!configuration.exists(resourcename)) {
            this.notFound(channel, "Resource '" + resourcename + "' not found.");
            return;
        }
        configuration.putCObject(READONLY_FIELD, this.readonlyFields);
        this.successResponse(channel, configuration);
    }

    @Override
    protected void handlePost(RestChannel channel, RestRequest request, Client client, JsonNode content) {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    @Override
    protected void handleDelete(RestChannel channel, RestRequest request, Client client, JsonNode content) {
        this.notImplemented(channel, RestRequest.Method.DELETE);
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        return new AuditValidator(request, ref, this.settings, params);
    }

    @Override
    protected String getResourceName() {
        return RESOURCE_NAME;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.AUDIT;
    }

    @Override
    protected CType getConfigName() {
        return CType.AUDIT;
    }

    @Override
    protected boolean isReadonlyFieldUpdated(JsonNode existingResource, JsonNode targetResource) {
        if (!this.isSuperAdmin()) {
            return this.readonlyFields.stream().anyMatch(path -> !existingResource.at(path).equals((Object)targetResource.at(path)));
        }
        return false;
    }

    @Override
    protected boolean isReadonlyFieldUpdated(SecurityDynamicConfiguration<?> configuration, JsonNode targetResource) {
        return this.isReadonlyFieldUpdated(Utils.convertJsonToJackson(configuration, false).get(this.getResourceName()), targetResource);
    }
}

