/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.dlic.rest.api;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationRepository;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.AbstractApiAction;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.api.Endpoint;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.support.Utils;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.validation.AccountValidator;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.Hashed;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.ssl.transport.PrincipalExtractor;
import com.amazon.opendistroforelasticsearch.security.support.SecurityJsonNode;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class AccountApiAction
extends AbstractApiAction {
    private static final String RESOURCE_NAME = "account";
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/api/account"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_security/api/account"));
    private final PrivilegesEvaluator privilegesEvaluator;
    private final ThreadContext threadContext;

    public AccountApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator privilegesEvaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, privilegesEvaluator, threadPool, auditLog);
        this.privilegesEvaluator = privilegesEvaluator;
        this.threadContext = threadPool.getThreadContext();
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        BytesRestResponse response;
        XContentBuilder builder = channel.newBuilder();
        try {
            builder.startObject();
            User user = (User)this.threadContext.getTransient("_opendistro_security_user");
            if (user != null) {
                TransportAddress remoteAddress = (TransportAddress)this.threadContext.getTransient("_opendistro_security_remote_address");
                Set<String> securityRoles = this.privilegesEvaluator.mapRoles(user, remoteAddress);
                SecurityDynamicConfiguration<?> configuration = this.load(this.getConfigName(), false);
                builder.field("user_name", user.getName()).field("is_reserved", this.isReserved(configuration, user.getName())).field("is_hidden", configuration.isHidden(user.getName())).field("is_internal_user", configuration.exists(user.getName())).field("user_requested_tenant", user.getRequestedTenant()).field("backend_roles", user.getRoles()).field("custom_attribute_names", user.getCustomAttributesMap().keySet()).field("tenants", this.privilegesEvaluator.mapTenants(user, securityRoles)).field("roles", securityRoles);
            }
            builder.endObject();
            response = new BytesRestResponse(RestStatus.OK, builder);
        }
        catch (Exception exception) {
            this.log.error(exception.toString(), (Throwable)exception);
            builder.startObject().field("error", exception.toString()).endObject();
            response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
        }
        channel.sendResponse((RestResponse)response);
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        final String username = user.getName();
        SecurityDynamicConfiguration<?> internalUser = this.load(CType.INTERNALUSERS, false);
        if (!internalUser.exists(username)) {
            this.notFound(channel, "Could not find user.");
            return;
        }
        if (!this.isWriteable(channel, internalUser, username)) {
            return;
        }
        SecurityJsonNode securityJsonNode = new SecurityJsonNode(content);
        String currentPassword = content.get("current_password").asText();
        Hashed internalUserEntry = (Hashed)internalUser.getCEntry(username);
        String currentHash = internalUserEntry.getHash();
        if (currentHash == null || !OpenBSDBCrypt.checkPassword((String)currentHash, (char[])currentPassword.toCharArray())) {
            this.badRequestResponse(channel, "Could not validate your current password.");
            return;
        }
        String password = securityJsonNode.get("password").asString();
        String hash = Strings.isNullOrEmpty((String)password) ? securityJsonNode.get("hash").asString() : Utils.hash(password.toCharArray());
        if (Strings.isNullOrEmpty((String)hash)) {
            this.badRequestResponse(channel, "Both provided password and hash cannot be null/empty.");
            return;
        }
        internalUserEntry.setHash(hash);
        this.saveAnUpdateConfigs(client, request, CType.INTERNALUSERS, internalUser, new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                AccountApiAction.this.successResponse(channel, "'" + username + "' updated.");
            }
        });
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        return new AccountValidator(request, ref, this.settings, user.getName());
    }

    @Override
    protected String getResourceName() {
        return RESOURCE_NAME;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.ACCOUNT;
    }

    @Override
    protected void filter(SecurityDynamicConfiguration<?> builder) {
        super.filter(builder);
        builder.clearHashes();
    }

    @Override
    protected CType getConfigName() {
        return CType.INTERNALUSERS;
    }
}

