/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.configuration;

import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesInterceptor;
import com.amazon.opendistroforelasticsearch.security.resolver.IndexResolverReplacer;
import com.amazon.opendistroforelasticsearch.security.securityconf.DynamicConfigModel;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.threadpool.ThreadPool;

public class PrivilegesInterceptorImpl
extends PrivilegesInterceptor {
    private static final String USER_TENANT = "__user__";
    private static final String EMPTY_STRING = "";
    private static final String KIBANA_INDEX_SUFFIX = "_1";
    private static final Map<String, Object> KIBANA_INDEX_SETTINGS = ImmutableMap.of((Object)"index.number_of_shards", (Object)1, (Object)"index.auto_expand_replicas", (Object)"0-1");
    protected final Logger log = LogManager.getLogger(this.getClass());

    public PrivilegesInterceptorImpl(IndexNameExpressionResolver resolver, ClusterService clusterService, Client client, ThreadPool threadPool) {
        super(resolver, clusterService, client, threadPool);
    }

    private boolean isTenantAllowed(ActionRequest request, String action, User user, Map<String, Boolean> tenants, String requestedTenant) {
        if (!tenants.keySet().contains(requestedTenant)) {
            this.log.warn("Tenant {} is not allowed for user {}", (Object)requestedTenant, (Object)user.getName());
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("request " + request.getClass());
        }
        if (tenants.get(requestedTenant) == Boolean.FALSE && action.startsWith("indices:data/write")) {
            this.log.warn("Tenant {} is not allowed to write (user: {})", (Object)requestedTenant, (Object)user.getName());
            return false;
        }
        return true;
    }

    @Override
    public PrivilegesInterceptor.ReplaceResult replaceKibanaIndex(ActionRequest request, String action, User user, DynamicConfigModel config, IndexResolverReplacer.Resolved requestedResolved, Map<String, Boolean> tenants) {
        boolean kibanaIndexOnly;
        boolean enabled = config.isKibanaMultitenancyEnabled();
        if (!enabled) {
            return CONTINUE_EVALUATION_REPLACE_RESULT;
        }
        String kibanaserverUsername = config.getKibanaServerUsername();
        String kibanaIndexName = config.getKibanaIndexname();
        String requestedTenant = user.getRequestedTenant();
        if (this.log.isDebugEnabled()) {
            this.log.debug("raw requestedTenant: '" + requestedTenant + "'");
        }
        boolean bl = kibanaIndexOnly = !user.getName().equals(kibanaserverUsername) && PrivilegesInterceptorImpl.resolveToKibanaIndexOrAlias(requestedResolved, kibanaIndexName);
        if (requestedTenant == null || requestedTenant.length() == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("No tenant, will resolve to " + kibanaIndexName);
            }
            if (kibanaIndexOnly && !this.isTenantAllowed(request, action, user, tenants, "global_tenant")) {
                return ACCESS_DENIED_REPLACE_RESULT;
            }
            return CONTINUE_EVALUATION_REPLACE_RESULT;
        }
        if (USER_TENANT.equals(requestedTenant)) {
            requestedTenant = user.getName();
        }
        if (this.log.isDebugEnabled() && !user.getName().equals(kibanaserverUsername)) {
            this.log.debug("requestedResolved: " + requestedResolved);
        }
        if (!user.getName().equals(kibanaserverUsername)) {
            Set<String> indices = requestedResolved.getAllIndices();
            String tenantIndexName = this.toUserIndexName(kibanaIndexName, requestedTenant);
            if (indices.size() == 1 && indices.iterator().next().startsWith(tenantIndexName) && this.isTenantAllowed(request, action, user, tenants, requestedTenant)) {
                return ACCESS_GRANTED_REPLACE_RESULT;
            }
        }
        if (kibanaIndexOnly) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("requestedTenant: " + requestedTenant);
                this.log.debug("is user tenant: " + requestedTenant.equals(user.getName()));
            }
            if (!this.isTenantAllowed(request, action, user, tenants, requestedTenant)) {
                return ACCESS_DENIED_REPLACE_RESULT;
            }
            String tenantIndexName = this.toUserIndexName(kibanaIndexName, requestedTenant);
            return PrivilegesInterceptorImpl.newAccessGrantedReplaceResult(this.replaceIndex(request, kibanaIndexName, tenantIndexName, action));
        }
        if (!user.getName().equals(kibanaserverUsername) && this.log.isTraceEnabled()) {
            this.log.trace("not a request to only the .kibana index");
            this.log.trace(user.getName() + "/" + kibanaserverUsername);
            this.log.trace(requestedResolved + " does not contain only " + kibanaIndexName);
        }
        return CONTINUE_EVALUATION_REPLACE_RESULT;
    }

    private CreateIndexRequest newCreateIndexRequestIfAbsent(String name) {
        SortedMap indicesLookup = this.clusterService.state().getMetadata().getIndicesLookup();
        String concreteName = name.concat(KIBANA_INDEX_SUFFIX);
        if (Arrays.stream(new String[]{name, concreteName}).map(s -> (IndexAbstraction)indicesLookup.get(s)).filter(Objects::nonNull).peek(ia -> this.log.debug("{} {} already exists", (Object)ia.getType(), (Object)ia.getName())).findFirst().isPresent()) {
            return null;
        }
        return new CreateIndexRequest(concreteName).alias(new Alias(name)).settings(KIBANA_INDEX_SETTINGS);
    }

    private CreateIndexRequest replaceIndex(ActionRequest request, String oldIndexName, String newIndexName, String action) {
        boolean kibOk = false;
        CreateIndexRequest createIndexRequest = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} index will be replaced with {} in this {} request", (Object)oldIndexName, (Object)newIndexName, (Object)request.getClass().getName());
        }
        String[] newIndexNames = new String[]{newIndexName};
        if (request instanceof CreateIndexRequest) {
            ((CreateIndexRequest)request).index(newIndexName.concat(KIBANA_INDEX_SUFFIX)).alias(new Alias(newIndexName));
            kibOk = true;
        } else if (request instanceof BulkRequest) {
            for (DocWriteRequest ar : ((BulkRequest)request).requests()) {
                if (ar instanceof DeleteRequest) {
                    ((DeleteRequest)ar).index(newIndexName);
                }
                if (ar instanceof IndexRequest) {
                    if (createIndexRequest == null) {
                        createIndexRequest = this.newCreateIndexRequestIfAbsent(newIndexName);
                    }
                    ((IndexRequest)ar).index(newIndexName);
                }
                if (!(ar instanceof UpdateRequest)) continue;
                ((UpdateRequest)ar).index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof MultiGetRequest) {
            for (MultiGetRequest.Item item : ((MultiGetRequest)request).getItems()) {
                item.index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof MultiSearchRequest) {
            for (SearchRequest ar : ((MultiSearchRequest)request).requests()) {
                ar.indices(newIndexNames);
            }
            kibOk = true;
        } else if (request instanceof MultiTermVectorsRequest) {
            for (TermVectorsRequest ar : () -> ((MultiTermVectorsRequest)request).iterator()) {
                ar.index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof UpdateRequest) {
            ((UpdateRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof IndexRequest) {
            createIndexRequest = this.newCreateIndexRequestIfAbsent(newIndexName);
            ((IndexRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof DeleteRequest) {
            ((DeleteRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof SingleShardRequest) {
            ((SingleShardRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof RefreshRequest) {
            ((RefreshRequest)request).indices(newIndexNames);
            kibOk = true;
        } else if (request instanceof ReplicationRequest) {
            ((ReplicationRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof IndicesRequest.Replaceable) {
            IndicesRequest.Replaceable replaceableRequest = (IndicesRequest.Replaceable)request;
            replaceableRequest.indices(newIndexNames);
            kibOk = true;
        } else if (request instanceof GetFieldMappingsIndexRequest || request instanceof GetFieldMappingsRequest) {
            kibOk = true;
        } else {
            this.log.warn("Dont know what to do (1) with {}", request.getClass());
        }
        if (!kibOk) {
            this.log.warn("Dont know what to do (2) with {}", request.getClass());
        }
        return createIndexRequest;
    }

    private String toUserIndexName(String originalKibanaIndex, String tenant) {
        if (tenant == null) {
            throw new ElasticsearchException("tenant must not be null here", new Object[0]);
        }
        return originalKibanaIndex + "_" + tenant.hashCode() + "_" + tenant.toLowerCase().replaceAll("[^a-z0-9]+", EMPTY_STRING);
    }

    private static boolean resolveToKibanaIndexOrAlias(IndexResolverReplacer.Resolved requestedResolved, String kibanaIndexName) {
        Set<String> allIndices = requestedResolved.getAllIndices();
        if (allIndices.size() == 1 && allIndices.iterator().next().equals(kibanaIndexName)) {
            return true;
        }
        Set<String> aliases = requestedResolved.getAliases();
        return aliases.size() == 1 && aliases.iterator().next().equals(kibanaIndexName);
    }
}

