/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.configuration;

import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.EmptyFilterLeafReader;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.securityconf.ConfigModel;
import com.amazon.opendistroforelasticsearch.security.support.ConfigConstants;
import com.amazon.opendistroforelasticsearch.security.support.HeaderHelper;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.user.User;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.greenrobot.eventbus.Subscribe;

public class OpenDistroSecurityIndexSearcherWrapper
implements CheckedFunction<DirectoryReader, DirectoryReader, IOException> {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final ThreadContext threadContext;
    protected final Index index;
    protected final String opendistrosecurityIndex;
    private final AdminDNs adminDns;
    private ConfigModel configModel;
    private final PrivilegesEvaluator evaluator;
    private final WildcardMatcher protectedIndexMatcher;
    private final WildcardMatcher allowedRolesMatcher;
    private final Boolean protectedIndexEnabled;
    private final Boolean systemIndexEnabled;
    private final WildcardMatcher systemIndexMatcher;

    public OpenDistroSecurityIndexSearcherWrapper(IndexService indexService, Settings settings, AdminDNs adminDNs, PrivilegesEvaluator evaluator) {
        this.index = indexService.index();
        this.threadContext = indexService.getThreadPool().getThreadContext();
        this.opendistrosecurityIndex = settings.get("opendistro_security.config_index_name", ".opendistro_security");
        this.evaluator = evaluator;
        this.adminDns = adminDNs;
        this.protectedIndexMatcher = WildcardMatcher.from(settings.getAsList("opendistro_security.protected_indices.indices"));
        this.allowedRolesMatcher = WildcardMatcher.from(settings.getAsList("opendistro_security.protected_indices.roles"));
        this.protectedIndexEnabled = settings.getAsBoolean("opendistro_security.protected_indices.enabled", ConfigConstants.OPENDISTRO_SECURITY_PROTECTED_INDICES_ENABLED_DEFAULT);
        this.systemIndexEnabled = settings.getAsBoolean("opendistro_security.system_indices.enabled", ConfigConstants.OPENDISTRO_SECURITY_SYSTEM_INDICES_ENABLED_DEFAULT);
        this.systemIndexMatcher = WildcardMatcher.from(settings.getAsList("opendistro_security.system_indices.indices"));
    }

    @Subscribe
    public void onConfigModelChanged(ConfigModel cm) {
        this.configModel = cm;
    }

    public final DirectoryReader apply(DirectoryReader reader) throws IOException {
        if (this.isSecurityIndexRequest() && !this.isAdminAuthenticatedOrInternalRequest()) {
            return new EmptyFilterLeafReader.EmptyDirectoryReader(reader);
        }
        if (this.protectedIndexEnabled.booleanValue() && this.isBlockedProtectedIndexRequest() && !this.isPermittedOnIndex()) {
            return new EmptyFilterLeafReader.EmptyDirectoryReader(reader);
        }
        if (this.systemIndexEnabled.booleanValue() && this.isBlockedSystemIndexRequest() && !this.isAdminDnOrPluginRequest()) {
            this.log.warn("search action for {} is not allowed for a non adminDN user", (Object)this.index.getName());
            return new EmptyFilterLeafReader.EmptyDirectoryReader(reader);
        }
        return this.dlsFlsWrap(reader, this.isAdminAuthenticatedOrInternalRequest());
    }

    protected DirectoryReader dlsFlsWrap(DirectoryReader reader, boolean isAdmin) throws IOException {
        return reader;
    }

    protected final boolean isAdminAuthenticatedOrInternalRequest() {
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        if (user != null && this.adminDns.isAdmin(user)) {
            return true;
        }
        return "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_opendistro_security_conf_request"));
    }

    protected final boolean isSecurityIndexRequest() {
        return this.index.getName().equals(this.opendistrosecurityIndex);
    }

    protected final boolean isBlockedProtectedIndexRequest() {
        return this.protectedIndexMatcher.test(this.index.getName());
    }

    protected final boolean isBlockedSystemIndexRequest() {
        return this.systemIndexMatcher.test(this.index.getName());
    }

    protected final boolean isAdminDnOrPluginRequest() {
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        if (user == null) {
            return true;
        }
        return this.adminDns.isAdmin(user);
    }

    protected final boolean isPermittedOnIndex() {
        TransportAddress caller;
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        Set<String> securityRoles = this.evaluator.mapRoles(user, caller = (TransportAddress)this.threadContext.getTransient("_opendistro_security_remote_address"));
        return this.allowedRolesMatcher.matchAny(securityRoles);
    }
}

