/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.configuration;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.compliance.ComplianceIndexingOperationListener;
import com.amazon.opendistroforelasticsearch.security.configuration.AdminDNs;
import com.amazon.opendistroforelasticsearch.security.configuration.DlsFlsFilterLeafReader;
import com.amazon.opendistroforelasticsearch.security.configuration.DlsQueryParser;
import com.amazon.opendistroforelasticsearch.security.configuration.OpenDistroSecurityIndexSearcherWrapper;
import com.amazon.opendistroforelasticsearch.security.configuration.Salt;
import com.amazon.opendistroforelasticsearch.security.privileges.PrivilegesEvaluator;
import com.amazon.opendistroforelasticsearch.security.support.HeaderHelper;
import com.amazon.opendistroforelasticsearch.security.support.OpenDistroSecurityUtils;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.Query;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;

public class OpenDistroSecurityFlsDlsIndexSearcherWrapper
extends OpenDistroSecurityIndexSearcherWrapper {
    private static final Set<String> metaFields = Sets.newHashSet((Object[])new String[]{"_source", "_version", "_field_names", "_seq_no", "_primary_term", "_id", "_ignored", "_index", "_routing", "_size", "_timestamp", "_ttl", "_type"});
    private final ClusterService clusterService;
    private final IndexService indexService;
    private final AuditLog auditlog;
    private final LongSupplier nowInMillis;
    private final Salt salt;

    public OpenDistroSecurityFlsDlsIndexSearcherWrapper(IndexService indexService, Settings settings, AdminDNs adminDNs, ClusterService clusterService, AuditLog auditlog, ComplianceIndexingOperationListener ciol, PrivilegesEvaluator evaluator, Salt salt) {
        super(indexService, settings, adminDNs, evaluator);
        ciol.setIs(indexService);
        this.clusterService = clusterService;
        this.indexService = indexService;
        this.auditlog = auditlog;
        boolean allowNowinDlsQueries = settings.getAsBoolean("opendistro_security.unsupported.allow_now_in_dls", Boolean.valueOf(false));
        this.nowInMillis = allowNowinDlsQueries ? () -> System.currentTimeMillis() : () -> {
            throw new IllegalArgumentException("'now' is not allowed in DLS queries");
        };
        this.log.debug("FLS/DLS {} enabled for index {}", (Object)this, (Object)indexService.index().getName());
        this.salt = salt;
    }

    @Override
    protected DirectoryReader dlsFlsWrap(DirectoryReader reader, boolean isAdmin) throws IOException {
        ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
        Sets.SetView flsFields = null;
        HashSet maskedFields = null;
        Query dlsQuery = null;
        if (!isAdmin) {
            Set unparsedDlsQueries;
            Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_fls_fields"));
            Map queries = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_dls_query"));
            Map maskedFieldsMap = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_masked_fields"));
            String flsEval = OpenDistroSecurityUtils.evalMap(allowedFlsFields, this.index.getName());
            String dlsEval = OpenDistroSecurityUtils.evalMap(queries, this.index.getName());
            String maskedEval = OpenDistroSecurityUtils.evalMap(maskedFieldsMap, this.index.getName());
            if (flsEval != null) {
                flsFields = Sets.union(metaFields, (Set)((Set)allowedFlsFields.get(flsEval)));
            }
            if (dlsEval != null && (unparsedDlsQueries = (Set)queries.get(dlsEval)) != null && !unparsedDlsQueries.isEmpty()) {
                dlsQuery = DlsQueryParser.parse(unparsedDlsQueries, this.indexService.newQueryShardContext(shardId.getId(), null, this.nowInMillis, null), this.indexService.xContentRegistry());
            }
            if (maskedEval != null) {
                maskedFields = new HashSet();
                maskedFields.addAll((Collection)maskedFieldsMap.get(maskedEval));
            }
        }
        return new DlsFlsFilterLeafReader.DlsFlsDirectoryReader(reader, (Set<String>)flsFields, dlsQuery, this.indexService, this.threadContext, this.clusterService, this.auditlog, maskedFields, shardId, this.salt);
    }
}

