/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.configuration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;

final class DlsQueryParser {
    private static final Query NON_NESTED_QUERY = new BooleanQuery.Builder().add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER).add((Query)new PrefixQuery(new Term("_type", "__")), BooleanClause.Occur.MUST_NOT).build();
    private static Cache<String, QueryBuilder> queries = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(4L, TimeUnit.HOURS).build();

    private DlsQueryParser() {
    }

    static Query parse(Set<String> unparsedDlsQueries, QueryShardContext queryShardContext, final NamedXContentRegistry namedXContentRegistry) throws IOException {
        if (unparsedDlsQueries == null || unparsedDlsQueries.isEmpty()) {
            return null;
        }
        boolean hasNestedMapping = queryShardContext.getMapperService().hasNested();
        BooleanQuery.Builder dlsQueryBuilder = new BooleanQuery.Builder();
        dlsQueryBuilder.setMinimumNumberShouldMatch(1);
        for (final String unparsedDlsQuery : unparsedDlsQueries) {
            try {
                QueryBuilder qb = (QueryBuilder)queries.get((Object)unparsedDlsQuery, (Callable)new Callable<QueryBuilder>(){

                    @Override
                    public QueryBuilder call() throws Exception {
                        XContentParser parser = JsonXContent.jsonXContent.createParser(namedXContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, unparsedDlsQuery);
                        QueryBuilder qb = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                        return qb;
                    }
                });
                ParsedQuery parsedQuery = queryShardContext.toQuery(qb);
                Query dlsQuery = parsedQuery.query();
                dlsQueryBuilder.add(dlsQuery, BooleanClause.Occur.SHOULD);
                if (!hasNestedMapping) continue;
                DlsQueryParser.handleNested(queryShardContext, dlsQueryBuilder, dlsQuery);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        return new ConstantScoreQuery((Query)dlsQueryBuilder.build());
    }

    static ParsedQuery parse(Set<String> unparsedDlsQueries, ParsedQuery originalQuery, QueryShardContext queryShardContext, final NamedXContentRegistry namedXContentRegistry) throws IOException {
        if (unparsedDlsQueries == null || unparsedDlsQueries.isEmpty()) {
            return null;
        }
        boolean hasNestedMapping = queryShardContext.getMapperService().hasNested();
        BooleanQuery.Builder dlsQueryBuilder = new BooleanQuery.Builder();
        dlsQueryBuilder.setMinimumNumberShouldMatch(1);
        for (final String unparsedDlsQuery : unparsedDlsQueries) {
            try {
                QueryBuilder qb = (QueryBuilder)queries.get((Object)unparsedDlsQuery, (Callable)new Callable<QueryBuilder>(){

                    @Override
                    public QueryBuilder call() throws Exception {
                        XContentParser parser = JsonXContent.jsonXContent.createParser(namedXContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, unparsedDlsQuery);
                        QueryBuilder qb = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                        return qb;
                    }
                });
                ParsedQuery parsedQuery = queryShardContext.toQuery(qb);
                ConstantScoreQuery dlsQuery = new ConstantScoreQuery(parsedQuery.query());
                dlsQueryBuilder.add((Query)dlsQuery, BooleanClause.Occur.SHOULD);
                if (!hasNestedMapping) continue;
                DlsQueryParser.handleNested(queryShardContext, dlsQueryBuilder, (Query)dlsQuery);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        dlsQueryBuilder.add(originalQuery.query(), BooleanClause.Occur.MUST);
        return new ParsedQuery((Query)dlsQueryBuilder.build());
    }

    private static void handleNested(QueryShardContext queryShardContext, BooleanQuery.Builder dlsQueryBuilder, Query parentQuery) {
        BitSetProducer parentDocumentsFilter = queryShardContext.bitsetFilter(NON_NESTED_QUERY);
        dlsQueryBuilder.add((Query)new ToChildBlockJoinQuery(parentQuery, parentDocumentsFilter), BooleanClause.Occur.SHOULD);
    }
}

