/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.configuration;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auditlog.config.AuditConfig;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigUpdateAlreadyInProgressException;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationChangeListener;
import com.amazon.opendistroforelasticsearch.security.configuration.ConfigurationLoaderSecurity7;
import com.amazon.opendistroforelasticsearch.security.configuration.InvalidConfigException;
import com.amazon.opendistroforelasticsearch.security.securityconf.DynamicConfigFactory;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.CType;
import com.amazon.opendistroforelasticsearch.security.securityconf.impl.SecurityDynamicConfiguration;
import com.amazon.opendistroforelasticsearch.security.ssl.util.ExceptionUtils;
import com.amazon.opendistroforelasticsearch.security.support.ConfigHelper;
import com.amazon.opendistroforelasticsearch.security.support.OpenDistroSecurityUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.threadpool.ThreadPool;

public class ConfigurationRepository {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationRepository.class);
    private final String opendistrosecurityIndex;
    private final Client client;
    private final Cache<CType, SecurityDynamicConfiguration<?>> configCache;
    private final List<ConfigurationChangeListener> configurationChangedListener;
    private final ConfigurationLoaderSecurity7 cl;
    private final Settings settings;
    private final ClusterService clusterService;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private DynamicConfigFactory dynamicConfigFactory;
    private static final int DEFAULT_CONFIG_VERSION = 2;
    private final Thread bgThread;
    private final AtomicBoolean installDefaultConfig = new AtomicBoolean();
    private final boolean acceptInvalid;
    private final Lock LOCK = new ReentrantLock();

    private ConfigurationRepository(final Settings settings, final Path configPath, final ThreadPool threadPool, final Client client, final ClusterService clusterService, final AuditLog auditLog) {
        this.opendistrosecurityIndex = settings.get("opendistro_security.config_index_name", ".opendistro_security");
        this.settings = settings;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.auditLog = auditLog;
        this.configurationChangedListener = new ArrayList<ConfigurationChangeListener>();
        this.acceptInvalid = settings.getAsBoolean("opendistro_security.unsupported.accept_invalid_config", Boolean.valueOf(false));
        this.cl = new ConfigurationLoaderSecurity7(client, threadPool, settings, clusterService);
        this.configCache = CacheBuilder.newBuilder().build();
        this.bgThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean isAuditConfigDocPresentInIndex;
                    Set<String> deprecatedAuditKeysInSettings;
                    block30: {
                        LOGGER.info("Background init thread started. Install default config?: " + ConfigurationRepository.this.installDefaultConfig.get());
                        if (ConfigurationRepository.this.installDefaultConfig.get()) {
                            try {
                                String lookupDir = System.getProperty("security.default_init.dir");
                                String cd = lookupDir != null ? lookupDir + "/" : new Environment(settings, configPath).pluginsFile().toAbsolutePath().toString() + "/opendistro_security/securityconfig/";
                                File confFile = new File(cd + "config.yml");
                                if (confFile.exists()) {
                                    ThreadContext threadContext = threadPool.getThreadContext();
                                    try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
                                        String auditConfigPath;
                                        threadContext.putHeader("_opendistro_security_conf_request", "true");
                                        boolean isSecurityIndexCreated = ConfigurationRepository.this.createSecurityIndexIfAbsent();
                                        if (isSecurityIndexCreated) {
                                            ConfigHelper.uploadFile(client, cd + "config.yml", ConfigurationRepository.this.opendistrosecurityIndex, CType.CONFIG, 2);
                                            ConfigHelper.uploadFile(client, cd + "roles.yml", ConfigurationRepository.this.opendistrosecurityIndex, CType.ROLES, 2);
                                            ConfigHelper.uploadFile(client, cd + "roles_mapping.yml", ConfigurationRepository.this.opendistrosecurityIndex, CType.ROLESMAPPING, 2);
                                            ConfigHelper.uploadFile(client, cd + "internal_users.yml", ConfigurationRepository.this.opendistrosecurityIndex, CType.INTERNALUSERS, 2);
                                            ConfigHelper.uploadFile(client, cd + "action_groups.yml", ConfigurationRepository.this.opendistrosecurityIndex, CType.ACTIONGROUPS, 2);
                                            ConfigHelper.uploadFile(client, cd + "tenants.yml", ConfigurationRepository.this.opendistrosecurityIndex, CType.TENANTS, 2);
                                            boolean populateEmptyIfFileMissing = true;
                                            ConfigHelper.uploadFile(client, cd + "nodes_dn.yml", ConfigurationRepository.this.opendistrosecurityIndex, CType.NODESDN, 2, true);
                                            ConfigHelper.uploadFile(client, cd + "whitelist.yml", ConfigurationRepository.this.opendistrosecurityIndex, CType.WHITELIST, 2, true);
                                            LOGGER.info("Default config applied");
                                        }
                                        if (new File(auditConfigPath = cd + "audit.yml").exists()) {
                                            ConfigHelper.uploadFile(client, auditConfigPath, ConfigurationRepository.this.opendistrosecurityIndex, CType.AUDIT, 2);
                                        }
                                        break block30;
                                    }
                                }
                                LOGGER.error("{} does not exist", (Object)confFile.getAbsolutePath());
                            }
                            catch (Exception e) {
                                LOGGER.debug("Cannot apply default config (this is maybe not an error!) due to {}", (Object)e.getMessage());
                            }
                        }
                    }
                    LOGGER.debug("Node started, try to initialize it. Wait for at least yellow cluster state....");
                    ClusterHealthResponse response = null;
                    try {
                        response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{ConfigurationRepository.this.opendistrosecurityIndex}).waitForActiveShards(1).waitForYellowStatus()).actionGet();
                    }
                    catch (Exception e1) {
                        LOGGER.debug("Catched a {} but we just try again ...", (Object)e1.toString());
                    }
                    while (response == null || response.isTimedOut() || response.getStatus() == ClusterHealthStatus.RED) {
                        LOGGER.debug("index '{}' not healthy yet, we try again ... (Reason: {})", (Object)ConfigurationRepository.this.opendistrosecurityIndex, (Object)(response == null ? "no response" : (response.isTimedOut() ? "timeout" : "other, maybe red cluster")));
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                        try {
                            response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{ConfigurationRepository.this.opendistrosecurityIndex}).waitForYellowStatus()).actionGet();
                        }
                        catch (Exception e1) {
                            LOGGER.debug("Catched again a {} but we just try again ...", (Object)e1.toString());
                        }
                    }
                    while (!ConfigurationRepository.this.dynamicConfigFactory.isInitialized()) {
                        try {
                            LOGGER.debug("Try to load config ...");
                            ConfigurationRepository.this.reloadConfiguration(Arrays.asList(CType.values()));
                        }
                        catch (Exception e) {
                            LOGGER.debug("Unable to load configuration due to {}", (Object)String.valueOf(ExceptionUtils.getRootCause(e)));
                            try {
                                Thread.sleep(3000L);
                                continue;
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                                LOGGER.debug("Thread was interrupted so we cancel initialization");
                            }
                        }
                        break;
                    }
                    if (!(deprecatedAuditKeysInSettings = AuditConfig.getDeprecatedKeys(settings)).isEmpty()) {
                        LOGGER.warn("Following keys {} are deprecated in elasticsearch settings. They will be removed in plugin v2.0.0.0", deprecatedAuditKeysInSettings);
                    }
                    if (isAuditConfigDocPresentInIndex = ConfigurationRepository.this.cl.isAuditConfigDocPresentInIndex()) {
                        if (!deprecatedAuditKeysInSettings.isEmpty()) {
                            LOGGER.warn("Audit configuration settings found in both index and elasticsearch settings (deprecated)");
                        }
                        LOGGER.info("Hot-reloading of audit configuration is enabled");
                    } else {
                        LOGGER.info("Hot-reloading of audit configuration is disabled. Using configuration with defaults from elasticsearch settings.  Populate the configuration in index using audit.yml or securityadmin to enable it.");
                        auditLog.setConfig(AuditConfig.from(settings));
                    }
                    LOGGER.info("Node '{}' initialized", (Object)clusterService.localNode().getName());
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected exception while initializing node " + e, (Throwable)e);
                }
            }
        });
    }

    private boolean createSecurityIndexIfAbsent() {
        try {
            ImmutableMap indexSettings = ImmutableMap.of((Object)"index.number_of_shards", (Object)1, (Object)"index.auto_expand_replicas", (Object)"0-all");
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(this.opendistrosecurityIndex).settings((Map)indexSettings);
            boolean ok = ((CreateIndexResponse)this.client.admin().indices().create(createIndexRequest).actionGet()).isAcknowledged();
            LOGGER.info("Index {} created?: {}", (Object)this.opendistrosecurityIndex, (Object)ok);
            return ok;
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            LOGGER.info("Index {} already exists", (Object)this.opendistrosecurityIndex);
            return false;
        }
    }

    public void initOnNodeStart() {
        try {
            if (this.settings.getAsBoolean("opendistro_security.allow_default_init_securityindex", Boolean.valueOf(false)).booleanValue()) {
                LOGGER.info("Will attempt to create index {} and default configs if they are absent", (Object)this.opendistrosecurityIndex);
                this.installDefaultConfig.set(true);
                this.bgThread.start();
            } else if (this.settings.getAsBoolean("opendistro_security.background_init_if_securityindex_not_exist", Boolean.valueOf(true)).booleanValue()) {
                LOGGER.info("Will not attempt to create index {} and default configs if they are absent. Use securityadmin to initialize cluster", (Object)this.opendistrosecurityIndex);
                this.bgThread.start();
            } else {
                LOGGER.info("Will not attempt to create index {} and default configs if they are absent. Will not perform background initialization", (Object)this.opendistrosecurityIndex);
            }
        }
        catch (Throwable e2) {
            LOGGER.error("Error during node initialization: {}", (Object)e2, (Object)e2);
            this.bgThread.start();
        }
    }

    public boolean isAuditHotReloadingEnabled() {
        return this.cl.isAuditConfigDocPresentInIndex();
    }

    public static ConfigurationRepository create(Settings settings, Path configPath, ThreadPool threadPool, Client client, ClusterService clusterService, AuditLog auditLog) {
        ConfigurationRepository repository = new ConfigurationRepository(settings, configPath, threadPool, client, clusterService, auditLog);
        return repository;
    }

    public void setDynamicConfigFactory(DynamicConfigFactory dynamicConfigFactory) {
        this.dynamicConfigFactory = dynamicConfigFactory;
    }

    public SecurityDynamicConfiguration<?> getConfiguration(CType configurationType) {
        SecurityDynamicConfiguration conf = (SecurityDynamicConfiguration)this.configCache.getIfPresent((Object)configurationType);
        if (conf != null) {
            return conf.deepClone();
        }
        return SecurityDynamicConfiguration.empty();
    }

    public void reloadConfiguration(Collection<CType> configTypes) throws ConfigUpdateAlreadyInProgressException {
        block6: {
            try {
                if (this.LOCK.tryLock(60L, TimeUnit.SECONDS)) {
                    try {
                        this.reloadConfiguration0(configTypes, this.acceptInvalid);
                        break block6;
                    }
                    finally {
                        this.LOCK.unlock();
                    }
                }
                throw new ConfigUpdateAlreadyInProgressException("A config update is already imn progress", new Object[0]);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConfigUpdateAlreadyInProgressException("Interrupted config update", new Object[0]);
            }
        }
    }

    private void reloadConfiguration0(Collection<CType> configTypes, boolean acceptInvalid) {
        Map<CType, SecurityDynamicConfiguration<?>> loaded = this.getConfigurationsFromIndex(configTypes, false, acceptInvalid);
        this.configCache.putAll(loaded);
        this.notifyAboutChanges(loaded);
    }

    public synchronized void subscribeOnChange(ConfigurationChangeListener listener) {
        this.configurationChangedListener.add(listener);
    }

    private synchronized void notifyAboutChanges(Map<CType, SecurityDynamicConfiguration<?>> typeToConfig) {
        for (ConfigurationChangeListener listener : this.configurationChangedListener) {
            try {
                LOGGER.debug("Notify {} listener about change configuration with type {}", (Object)listener);
                listener.onChange(typeToConfig);
            }
            catch (Exception e) {
                LOGGER.error("{} listener errored: " + e, (Object)listener, (Object)e);
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }
    }

    public Map<CType, SecurityDynamicConfiguration<?>> getConfigurationsFromIndex(Collection<CType> configTypes, boolean logComplianceEvent) {
        return this.getConfigurationsFromIndex(configTypes, logComplianceEvent, this.acceptInvalid);
    }

    public Map<CType, SecurityDynamicConfiguration<?>> getConfigurationsFromIndex(Collection<CType> configTypes, boolean logComplianceEvent, boolean acceptInvalid) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        HashMap retVal = new HashMap();
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            MappingMetadata mappingMetadata;
            threadContext.putHeader("_opendistro_security_conf_request", "true");
            IndexMetadata securityMetadata = this.clusterService.state().metadata().index(this.opendistrosecurityIndex);
            MappingMetadata mappingMetadata2 = mappingMetadata = securityMetadata == null ? null : securityMetadata.mapping();
            if (securityMetadata != null && mappingMetadata != null) {
                if ("security".equals(mappingMetadata.type())) {
                    LOGGER.debug("security index exists and was created before ES 7 (legacy layout)");
                } else {
                    LOGGER.debug("security index exists and was created with ES 7 (new layout)");
                }
                retVal.putAll(this.validate(this.cl.load(configTypes.toArray(new CType[0]), 5L, TimeUnit.SECONDS, acceptInvalid), configTypes.size()));
            } else {
                LOGGER.debug("security index not exists (yet)");
                retVal.putAll(this.validate(this.cl.load(configTypes.toArray(new CType[0]), 5L, TimeUnit.SECONDS, acceptInvalid), configTypes.size()));
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException((Throwable)e);
        }
        if (logComplianceEvent && this.auditLog.getComplianceConfig().isEnabled()) {
            CType configurationType = configTypes.iterator().next();
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put(configurationType.toLCString(), Strings.toString((ToXContent)((ToXContent)retVal.get((Object)configurationType))));
            this.auditLog.logDocumentRead(this.opendistrosecurityIndex, configurationType.toLCString(), null, fields);
        }
        return retVal;
    }

    private Map<CType, SecurityDynamicConfiguration<?>> validate(Map<CType, SecurityDynamicConfiguration<?>> conf, int expectedSize) throws InvalidConfigException {
        if (conf == null || conf.size() != expectedSize) {
            throw new InvalidConfigException("Retrieved only partial configuration");
        }
        return conf;
    }

    private static String formatDate(long date) {
        return new SimpleDateFormat("yyyy-MM-dd", OpenDistroSecurityUtils.EN_Locale).format(new Date(date));
    }

    public static int getDefaultConfigVersion() {
        return 2;
    }
}

