/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.configuration;

import com.amazon.opendistroforelasticsearch.security.securityconf.DynamicConfigModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.greenrobot.eventbus.Subscribe;

public class CompatConfig {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Settings staticSettings;
    private DynamicConfigModel dcm;

    public CompatConfig(Environment environment) {
        this.staticSettings = environment.settings();
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.dcm = dcm;
        this.log.debug("dynamicSecurityConfig updated?: {}", (Object)(dcm != null ? 1 : 0));
    }

    public boolean restAuthEnabled() {
        boolean restInitiallyDisabled = this.staticSettings.getAsBoolean("opendistro_security.unsupported.disable_rest_auth_initially", Boolean.valueOf(false));
        if (restInitiallyDisabled) {
            if (this.dcm == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("dynamicSecurityConfig is null, initially static restDisabled");
                }
                return false;
            }
            boolean restDynamicallyDisabled = this.dcm.isRestAuthDisabled();
            if (this.log.isTraceEnabled()) {
                this.log.trace("opendistro_security.dynamic.disable_rest_auth {}", (Object)restDynamicallyDisabled);
            }
            return !restDynamicallyDisabled;
        }
        return true;
    }

    public boolean transportInterClusterAuthEnabled() {
        boolean interClusterAuthInitiallyDisabled = this.staticSettings.getAsBoolean("opendistro_security.unsupported.disable_intertransport_auth_initially", Boolean.valueOf(false));
        if (interClusterAuthInitiallyDisabled) {
            if (this.dcm == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("dynamicSecurityConfig is null, initially static interClusterAuthDisabled");
                }
                return false;
            }
            boolean interClusterAuthDynamicallyDisabled = this.dcm.isInterTransportAuthDisabled();
            if (this.log.isTraceEnabled()) {
                this.log.trace("opendistro_security.dynamic.disable_intertransport_auth {}", (Object)interClusterAuthDynamicallyDisabled);
            }
            return !interClusterAuthDynamicallyDisabled;
        }
        return true;
    }
}

