/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.configuration;

import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public class AdminDNs {
    protected final Logger log = LogManager.getLogger(AdminDNs.class);
    private final Set<LdapName> adminDn = new HashSet<LdapName>();
    private final Set<String> adminUsernames = new HashSet<String>();
    private final Map<LdapName, WildcardMatcher> allowedDnsImpersonations;
    private final Map<String, WildcardMatcher> allowedRestImpersonations;
    private boolean injectUserEnabled;
    private boolean injectAdminUserEnabled;

    public AdminDNs(Settings settings) {
        this.injectUserEnabled = settings.getAsBoolean("opendistro_security.unsupported.inject_user.enabled", Boolean.valueOf(false));
        this.injectAdminUserEnabled = settings.getAsBoolean("opendistro_security.unsupported.inject_user.admin.enabled", Boolean.valueOf(false));
        List adminDnsA = settings.getAsList("opendistro_security.authcz.admin_dn", Collections.emptyList());
        for (String dn : adminDnsA) {
            try {
                this.log.debug("{} is registered as an admin dn", (Object)dn);
                this.adminDn.add(new LdapName(dn));
            }
            catch (InvalidNameException e) {
                if (this.injectUserEnabled && this.injectAdminUserEnabled) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Admin DN not an LDAP name, but admin user injection enabled. Will add {} to admin usernames", (Object)dn);
                    }
                    this.adminUsernames.add(dn);
                    continue;
                }
                this.log.error("Unable to parse admin dn {}", (Object)dn, (Object)e);
            }
        }
        this.log.debug("Loaded {} admin DN's {}", (Object)this.adminDn.size(), this.adminDn);
        Settings impersonationDns = settings.getByPrefix("opendistro_security.authcz.impersonation_dn.");
        this.allowedDnsImpersonations = (Map)impersonationDns.keySet().stream().map(this::toLdapName).filter(Objects::nonNull).collect(ImmutableMap.toImmutableMap(Function.identity(), ldapName -> WildcardMatcher.from(settings.getAsList("opendistro_security.authcz.impersonation_dn." + ldapName))));
        this.log.debug("Loaded {} impersonation DN's {}", (Object)this.allowedDnsImpersonations.size(), this.allowedDnsImpersonations);
        Settings impersonationUsersRest = settings.getByPrefix("opendistro_security.authcz.rest_impersonation_user.");
        this.allowedRestImpersonations = (Map)impersonationUsersRest.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), user -> WildcardMatcher.from(settings.getAsList("opendistro_security.authcz.rest_impersonation_user." + user))));
        this.log.debug("Loaded {} impersonation users for REST {}", (Object)this.allowedRestImpersonations.size(), this.allowedRestImpersonations);
    }

    private LdapName toLdapName(String dn) {
        try {
            return new LdapName(dn);
        }
        catch (InvalidNameException e) {
            this.log.error("Unable to parse allowedImpersonations dn {}", (Object)dn, (Object)e);
            return null;
        }
    }

    public boolean isAdmin(User user) {
        if (this.isAdminDN(user.getName())) {
            return true;
        }
        return this.injectUserEnabled && this.injectAdminUserEnabled && user.isInjected() && this.adminUsernames.contains(user.getName());
    }

    public boolean isAdminDN(String dn) {
        if (dn == null) {
            return false;
        }
        try {
            return this.isAdminDN(new LdapName(dn));
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    private boolean isAdminDN(LdapName dn) {
        if (dn == null) {
            return false;
        }
        boolean isAdmin = this.adminDn.contains(dn);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Is principal {} an admin cert? {}", (Object)dn.toString(), (Object)isAdmin);
        }
        return isAdmin;
    }

    public boolean isTransportImpersonationAllowed(LdapName dn, String impersonated) {
        if (dn == null) {
            return false;
        }
        return this.isAdminDN(dn) || this.allowedDnsImpersonations.getOrDefault(dn, WildcardMatcher.NONE).test(impersonated);
    }

    public boolean isRestImpersonationAllowed(String originalUser, String impersonated) {
        return originalUser != null ? this.allowedRestImpersonations.getOrDefault(originalUser, WildcardMatcher.NONE).test(impersonated) : false;
    }
}

