/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.compliance;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.compliance.ComplianceConfig;
import com.amazon.opendistroforelasticsearch.security.compliance.ComplianceIndexingOperationListener;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;

public final class ComplianceIndexingOperationListenerImpl
extends ComplianceIndexingOperationListener {
    private static final Logger log = LogManager.getLogger(ComplianceIndexingOperationListenerImpl.class);
    private final AuditLog auditlog;
    private volatile IndexService is;
    private static final ThreadLocal<Context> threadContext = new ThreadLocal();

    public ComplianceIndexingOperationListenerImpl(AuditLog auditlog) {
        this.auditlog = auditlog;
    }

    @Override
    public void setIs(IndexService is) {
        if (this.is != null) {
            throw new ElasticsearchException("Index service already set", new Object[0]);
        }
        this.is = is;
    }

    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        ComplianceConfig complianceConfig = this.auditlog.getComplianceConfig();
        if (ComplianceIndexingOperationListenerImpl.isLoggingWriteEnabled(complianceConfig, shardId.getIndexName())) {
            Objects.requireNonNull(this.is);
            if (result.getFailure() == null && result.isFound() && delete.origin() == Engine.Operation.Origin.PRIMARY) {
                this.auditlog.logDocumentDeleted(shardId, delete, result);
            }
        }
    }

    public Engine.Index preIndex(ShardId shardId, Engine.Index index) {
        block9: {
            if (ComplianceIndexingOperationListenerImpl.isLoggingWriteDiffEnabled(this.auditlog.getComplianceConfig(), shardId.getIndexName())) {
                Objects.requireNonNull(this.is);
                if (index.origin() != Engine.Operation.Origin.PRIMARY) {
                    return index;
                }
                IndexShard shard = this.is.getShardOrNull(shardId.getId());
                if (shard == null) {
                    return index;
                }
                if (shard.isReadAllowed()) {
                    try {
                        GetResult getResult = shard.getService().getForUpdate(index.type(), index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm());
                        if (getResult.isExists()) {
                            threadContext.set(new Context(getResult));
                            break block9;
                        }
                        threadContext.set(new Context(null));
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Cannot retrieve original document due to {}", (Object)e.toString());
                        }
                        break block9;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Cannot read from shard {}", (Object)shardId);
                }
            }
        }
        return index;
    }

    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (ComplianceIndexingOperationListenerImpl.isLoggingWriteDiffEnabled(this.auditlog.getComplianceConfig(), shardId.getIndexName())) {
            threadContext.remove();
        }
    }

    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        ComplianceConfig complianceConfig = this.auditlog.getComplianceConfig();
        if (!ComplianceIndexingOperationListenerImpl.isLoggingWriteEnabled(complianceConfig, shardId.getIndexName())) {
            return;
        }
        if (complianceConfig.shouldLogDiffsForWrite()) {
            Context context = threadContext.get();
            GetResult previousContent = context == null ? null : context.getGetResult();
            threadContext.remove();
            Objects.requireNonNull(this.is);
            if (result.getFailure() != null || index.origin() != Engine.Operation.Origin.PRIMARY) {
                return;
            }
            if (this.is.getShardOrNull(shardId.getId()) == null) {
                return;
            }
            if (previousContent == null) {
                if (!result.isCreated()) {
                    log.warn("No previous content and not created (its an update but do not find orig source) for {}", (Object)(index.startTime() + "/" + shardId + "/" + index.type() + "/" + index.id()));
                }
                assert (result.isCreated()) : "No previous content and not created";
            } else {
                if (result.isCreated()) {
                    log.warn("Previous content and created for {}", (Object)(index.startTime() + "/" + shardId + "/" + index.type() + "/" + index.id()));
                }
                assert (!result.isCreated()) : "Previous content and created";
            }
            this.auditlog.logDocumentWritten(shardId, previousContent, index, result);
        } else {
            if (result.getFailure() != null || index.origin() != Engine.Operation.Origin.PRIMARY) {
                return;
            }
            this.auditlog.logDocumentWritten(shardId, null, index, result);
        }
    }

    private static boolean isLoggingWriteEnabled(ComplianceConfig complianceConfig, String indexName) {
        return complianceConfig != null && complianceConfig.writeHistoryEnabledForIndex(indexName);
    }

    private static boolean isLoggingWriteDiffEnabled(ComplianceConfig complianceConfig, String indexName) {
        return ComplianceIndexingOperationListenerImpl.isLoggingWriteEnabled(complianceConfig, indexName) && complianceConfig.shouldLogDiffsForWrite();
    }

    private static final class Context {
        private final GetResult getResult;

        public Context(GetResult getResult) {
            this.getResult = getResult;
        }

        public GetResult getGetResult() {
            return this.getResult;
        }
    }
}

