/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auth.limiting;

import com.amazon.opendistroforelasticsearch.security.auth.AuthFailureListener;
import com.amazon.opendistroforelasticsearch.security.auth.blocking.ClientBlockRegistry;
import com.amazon.opendistroforelasticsearch.security.auth.blocking.HeapBasedClientBlockRegistry;
import com.amazon.opendistroforelasticsearch.security.user.AuthCredentials;
import com.amazon.opendistroforelasticsearch.security.util.ratetracking.RateTracker;
import java.net.InetAddress;
import java.nio.file.Path;
import org.elasticsearch.common.settings.Settings;

public abstract class AbstractRateLimiter<ClientIdType>
implements AuthFailureListener,
ClientBlockRegistry<ClientIdType> {
    protected final ClientBlockRegistry<ClientIdType> clientBlockRegistry;
    protected final RateTracker<ClientIdType> rateTracker;

    public AbstractRateLimiter(Settings settings, Path configPath, Class<ClientIdType> clientIdType) {
        this.clientBlockRegistry = new HeapBasedClientBlockRegistry<ClientIdType>(settings.getAsInt("block_expiry_seconds", Integer.valueOf(600)) * 1000, settings.getAsInt("max_blocked_clients", Integer.valueOf(100000)), clientIdType);
        this.rateTracker = RateTracker.create(settings.getAsInt("time_window_seconds", Integer.valueOf(3600)) * 1000, settings.getAsInt("allowed_tries", Integer.valueOf(10)), settings.getAsInt("max_tracked_clients", Integer.valueOf(100000)));
    }

    @Override
    public abstract void onAuthFailure(InetAddress var1, AuthCredentials var2, Object var3);

    @Override
    public boolean isBlocked(ClientIdType clientId) {
        return this.clientBlockRegistry.isBlocked(clientId);
    }

    @Override
    public void block(ClientIdType clientId) {
        this.clientBlockRegistry.block(clientId);
        this.rateTracker.reset(clientId);
    }

    @Override
    public Class<ClientIdType> getClientIdType() {
        return this.clientBlockRegistry.getClientIdType();
    }
}

